/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestSourceType;
import net.thucydides.junit.listeners.JUnitStepListenerBuilder;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitStepListener
extends RunListener {
    private BaseStepListener baseStepListener;
    private StepListener[] extraListeners;
    private Map<String, List<String>> failedTests = Collections.synchronizedMap(new HashMap());
    private Class<?> testClass;
    private boolean testStarted = false;

    public static JUnitStepListenerBuilder withOutputDirectory(File outputDirectory) {
        return new JUnitStepListenerBuilder(outputDirectory);
    }

    protected JUnitStepListener(Class<?> testClass, BaseStepListener baseStepListener, StepListener ... listeners) {
        this.baseStepListener = baseStepListener;
        this.extraListeners = listeners;
        this.testClass = testClass;
        this.registerThucydidesListeners();
    }

    public void registerThucydidesListeners() {
        StepEventBus.getEventBus().registerListener((StepListener)this.baseStepListener);
        for (StepListener listener : this.extraListeners) {
            StepEventBus.getEventBus().registerListener(listener);
        }
    }

    public BaseStepListener getBaseStepListener() {
        return this.baseStepListener;
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
    }

    StepEventBus stepEventBus() {
        return this.baseStepListener.getEventBus();
    }

    public void testRunFinished(Result result) throws Exception {
        this.stepEventBus().testRunFinished();
        super.testRunFinished(result);
    }

    public void testStarted(Description description) {
        if (this.testingThisTest(description)) {
            this.startTestSuiteForFirstTest(description);
            this.stepEventBus().clear();
            this.stepEventBus().setTestSource(TestSourceType.TEST_SOURCE_JUNIT.getValue());
            this.stepEventBus().testStarted(Optional.ofNullable(description.getMethodName()).orElse("Initialisation"), description.getTestClass());
            this.startTest();
        }
    }

    private void startTestSuiteForFirstTest(Description description) {
        if (!this.getBaseStepListener().testSuiteRunning()) {
            this.stepEventBus().testSuiteStarted(description.getTestClass());
        }
    }

    public void testFinished(Description description) throws Exception {
        if (this.testingThisTest(description)) {
            this.updateResultsUsingTestAnnotations(description);
            this.stepEventBus().testFinished();
            this.stepEventBus().setTestSource(null);
            this.endTest();
        }
    }

    private void updateResultsUsingTestAnnotations(Description description) {
        Test testAnnotation = (Test)description.getAnnotation(Test.class);
        if (testAnnotation.expected() != null) {
            this.updateResultsForExpectedException(testAnnotation.expected());
        }
    }

    private void updateResultsForExpectedException(Class<? extends Throwable> expected) {
        this.stepEventBus().exceptionExpected(expected);
    }

    public void testFailure(Failure failure) throws Exception {
        if (this.testingThisTest(failure.getDescription())) {
            this.startTestIfNotYetStarted(failure.getDescription());
            this.stepEventBus().testFailed(failure.getException());
            this.updateFailureList(failure);
            this.endTest();
        }
    }

    private void updateFailureList(Failure failure) {
        String failedClassName = failure.getDescription().getClassName();
        List<String> failedMethods = this.failedTests.get(failedClassName);
        if (failedMethods == null) {
            failedMethods = new ArrayList<String>();
            this.failedTests.put(failedClassName, failedMethods);
        }
        failedMethods.add(failure.getDescription().getMethodName());
    }

    private void startTestIfNotYetStarted(Description description) {
        if (!this.testStarted) {
            this.testStarted(description);
        }
    }

    public void testIgnored(Description description) throws Exception {
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.baseStepListener.getTestOutcomes();
    }

    public FailureCause getError() {
        return this.baseStepListener.getTestFailureCause();
    }

    public boolean hasRecordedFailures() {
        return this.baseStepListener.aStepHasFailed();
    }

    public void dropListeners() {
        StepEventBus.getEventBus().dropListener((StepListener)this.baseStepListener);
        for (StepListener listener : this.extraListeners) {
            this.stepEventBus().dropListener(listener);
        }
    }

    private void startTest() {
        this.testStarted = true;
    }

    private void endTest() {
        this.testStarted = false;
    }

    private boolean testingThisTest(Description description) {
        return description.getTestClass() != null && description.getTestClass().equals(this.testClass);
    }

    protected Class<?> getTestClass() {
        return this.testClass;
    }

    public Map<String, List<String>> getFailedTests() {
        return this.failedTests;
    }
}

