/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.io.Serializable;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.time.SystemClock;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioStepsStepDelayer;
import net.thucydides.core.steps.WaitForBuilder;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioSteps
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioSteps.class);
    private Pages pages;
    private final SystemClock clock;

    public ScenarioSteps() {
        this.clock = SerenityInfrastructure.getClock();
    }

    public ScenarioSteps(Pages pages) {
        this.pages = pages;
        this.clock = SerenityInfrastructure.getClock();
    }

    public WebDriver getDriver() {
        return this.pages.getDriver();
    }

    protected void setPages(Pages pages) {
        this.pages = pages;
    }

    public Pages getPages() {
        return this.pages;
    }

    public Pages onPage() {
        return this.pages;
    }

    public Pages pages() {
        return this.getPages();
    }

    public <T extends ScenarioSteps> T onSamePage(Class<T> stepsType) {
        this.getPages().onSamePage();
        return (T)((ScenarioSteps)stepsType.cast(this));
    }

    public void waitABit(long delayInMilliseconds) {
        try {
            Thread.sleep(delayInMilliseconds);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait a bit method was interrupted.", (Throwable)e);
        }
    }

    public WaitForBuilder<? extends ScenarioSteps> waitFor(int duration) {
        return new ScenarioStepsStepDelayer<ScenarioSteps>(this.clock, this).waitFor(duration);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

