/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.codec.digest.DigestUtils;

public class ScreenshotDigest {
    private final Optional<BlurLevel> blurLevel;
    private final EnvironmentVariables environmentVariables;

    public ScreenshotDigest(EnvironmentVariables environmentVariables, BlurLevel blurLevel) {
        this.environmentVariables = environmentVariables;
        this.blurLevel = Optional.ofNullable(blurLevel);
    }

    public String forScreenshot(File screenshotFile) throws IOException {
        try (FileInputStream screenshot = new FileInputStream(screenshotFile);){
            String string = DigestUtils.sha256Hex((InputStream)screenshot) + "_" + this.blurLevel.orElse(BlurLevel.NONE).toString() + this.optionalWidth() + ".png";
            return string;
        }
    }

    private String optionalWidth() {
        return ThucydidesSystemProperty.SERENITY_RESIZED_IMAGE_WIDTH.from(this.environmentVariables, "");
    }
}

