/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.webdriver.FirefoxOptionsEnhancer;
import net.serenitybdd.core.webdriver.driverproviders.DownloadableDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EnhanceCapabilitiesWithFixtures;
import net.serenitybdd.core.webdriver.driverproviders.UpdateDriverEnvironmentProperty;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestContext;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;

public class FirefoxDriverProvider
extends DownloadableDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public FirefoxDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = SerenityInfrastructure.getDriverCapabilityRecord();
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        this.downloadDriverIfRequired("firefox", environmentVariables);
        UpdateDriverEnvironmentProperty.forDriverProperty("webdriver.gecko.driver");
        FirefoxOptions firefoxOptions = W3CCapabilities.definedIn(environmentVariables).withPrefix("webdriver.capabilities").firefoxOptions();
        FirefoxOptionsEnhancer.enhanceOptions(firefoxOptions).using(environmentVariables);
        firefoxOptions.addArguments(this.argumentsIn(options));
        if (ThucydidesSystemProperty.HEADLESS_MODE.booleanFrom(environmentVariables).booleanValue()) {
            firefoxOptions.addArguments(new String[]{"-headless"});
        }
        FirefoxOptions enhancedOptions = (FirefoxOptions)EnhanceCapabilitiesWithFixtures.using(this.fixtureProviderService).into((MutableCapabilities)firefoxOptions);
        TestContext.forTheCurrentTest().recordBrowserConfiguration((Capabilities)enhancedOptions);
        TestContext.forTheCurrentTest().recordCurrentPlatform();
        this.driverProperties.registerCapabilities("firefox", this.capabilitiesToProperties((Capabilities)enhancedOptions));
        return new FirefoxDriver(enhancedOptions);
    }
}

