/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.steps.UIInteractionSteps;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.Steps;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.PageFactory;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.webdriver.Configuration;

public class PageObjectDependencyInjector
implements DependencyInjector {
    EnvironmentDependencyInjector environmentDependencyInjector = new EnvironmentDependencyInjector();
    Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
    private static final List<Field> NO_FIELDS = new ArrayList<Field>();

    public PageObjectDependencyInjector(Pages pages) {
        this();
    }

    public PageObjectDependencyInjector() {
    }

    public void injectDependenciesInto(Object target) {
        this.environmentDependencyInjector.injectDependenciesInto(target);
        List<Field> pageObjectFields = this.pageObjectFieldsIn(target);
        this.updatePageObject(target);
        for (Field pageObjectField : this.nonAbstract(pageObjectFields)) {
            this.instantiatePageObjectIfNotAssigned(pageObjectField, target);
        }
    }

    private List<Field> nonAbstract(List<Field> pageObjectFields) {
        ArrayList<Field> concretePageObjectFields = new ArrayList<Field>();
        for (Field field : pageObjectFields) {
            if (Modifier.isAbstract(field.getType().getModifiers())) continue;
            concretePageObjectFields.add(field);
        }
        return concretePageObjectFields;
    }

    public void reset() {
    }

    private void instantiatePageObjectIfNotAssigned(Field pageObjectField, Object target) {
        PageFactory factory = new PageFactory(Serenity.getWebdriverManager().getWebdriver());
        try {
            pageObjectField.setAccessible(true);
            if (this.shouldInstrumentField(pageObjectField)) {
                StepAnnotations.injector().instrumentStepsInField(target, pageObjectField, Serenity.getStepFactory());
            }
            if (pageObjectField.get(target) != null) {
                this.updatePageObject(pageObjectField.get(target));
                return;
            }
            Class<?> pageObjectClass = pageObjectField.getType();
            Object newPageObject = factory.createPageOfType(pageObjectClass);
            this.injectDependenciesInto(newPageObject);
            pageObjectField.set(target, newPageObject);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate page objects in " + target);
        }
    }

    private boolean shouldInstrumentField(Field pageObjectField) {
        return pageObjectField.getDeclaringClass().isAssignableFrom(UIInteractionSteps.class) || pageObjectField.getAnnotation(Steps.class) != null;
    }

    private void updatePageObject(Object pageObject) {
        if (pageObject instanceof PageObject) {
            ((PageObject)pageObject).setDriver(Serenity.getWebdriverManager().getWebdriver());
            ((PageObject)pageObject).setDefaultBaseUrl(this.configuration.getBaseUrl());
        }
    }

    private List<Field> pageObjectFieldsIn(Object target) {
        if (target == null) {
            return NO_FIELDS;
        }
        Set allFields = Fields.of(target.getClass()).allFields();
        return allFields.stream().filter(field -> PageObject.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
    }
}

