/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.ChromeDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ConfigureChromeOptions;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EnhanceDriver;
import net.serenitybdd.core.webdriver.driverproviders.ProvideNewDriver;
import net.serenitybdd.core.webdriver.driverproviders.webdrivermanager.WebDriverManagerSetup;
import net.serenitybdd.core.webdriver.servicepools.ChromeServicePool;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverProvider
implements DriverProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DriverCapabilityRecord driverProperties;
    private final DriverServicePool driverServicePool = new ChromeServicePool();
    private final FixtureProviderService fixtureProviderService;

    public ChromeDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        if (this.isDriverAutomaticallyDownloaded(environmentVariables)) {
            this.logger.info("Using automatically driver download");
            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forChrome();
        } else {
            this.logger.info("Not using automatically driver download");
        }
        DesiredCapabilities enhancedCapabilities = this.enhancedCapabilitiesConfiguredIn(environmentVariables, options);
        this.driverProperties.registerCapabilities("chrome", this.capabilitiesToProperties((Capabilities)enhancedCapabilities));
        ChromeOptions chromeOptions = this.chromeDriverCapabilitiesDefinedIn(environmentVariables, options).configuredOptions();
        enhancedCapabilities.asMap().forEach((arg_0, arg_1) -> ((ChromeOptions)chromeOptions).setCapability(arg_0, arg_1));
        ChromeOptions enhancedChromeOptions = ConfigureChromeOptions.from(environmentVariables).to(chromeOptions);
        WebDriver newDriver = ProvideNewDriver.withConfiguration(environmentVariables, enhancedCapabilities, this.driverServicePool, DriverServicePool::newDriver, (pool, capabilities) -> new ChromeDriver(enhancedChromeOptions));
        EnhanceDriver.from(environmentVariables).to(newDriver);
        return newDriver;
    }

    private DesiredCapabilities enhancedCapabilitiesConfiguredIn(EnvironmentVariables environmentVariables, String options) {
        DesiredCapabilities capabilities = this.chromeDriverCapabilitiesDefinedIn(environmentVariables, options).getCapabilities();
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        return enhancer.enhanced(capabilities, SupportedWebDriver.CHROME);
    }

    private ChromeDriverCapabilities chromeDriverCapabilitiesDefinedIn(EnvironmentVariables environmentVariables, String options) {
        return new ChromeDriverCapabilities(environmentVariables, options);
    }
}

