/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.locators.SmartElementLocatorFactory;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.WebDriverType;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

public class ElementLocatorFactorySelector {
    private final int timeoutInSeconds;
    private final EnvironmentVariables environmentVariables;
    private final AppiumConfiguration appiumConfiguration;

    public ElementLocatorFactorySelector(Configuration configuration) {
        this(configuration.getElementTimeoutInSeconds(), configuration.getEnvironmentVariables());
    }

    public ElementLocatorFactorySelector(int timeoutInSeconds, EnvironmentVariables environmentVariables) {
        this.timeoutInSeconds = timeoutInSeconds;
        this.environmentVariables = environmentVariables.copy();
        this.appiumConfiguration = AppiumConfiguration.from(environmentVariables);
    }

    public ElementLocatorFactory getLocatorFor(WebDriver driver) {
        return this.getLocatorFor((SearchContext)driver, driver);
    }

    public ElementLocatorFactory getLocatorFor(SearchContext searchContext, WebDriver driver) {
        String locatorType = ThucydidesSystemProperty.SERENITY_LOCATOR_FACTORY.from(this.environmentVariables, "SmartElementLocatorFactory");
        if (locatorType.equals("AjaxElementLocatorFactory")) {
            return new AjaxElementLocatorFactory(searchContext, this.timeoutInSeconds);
        }
        if (locatorType.equals("DefaultElementLocatorFactory")) {
            return new DefaultElementLocatorFactory(searchContext);
        }
        if (locatorType.equals("SmartElementLocatorFactory")) {
            return new SmartElementLocatorFactory(searchContext, this.platformFor(driver));
        }
        throw new IllegalArgumentException("Unsupported ElementLocatorFactory implementation: " + locatorType);
    }

    private MobilePlatform platformFor(WebDriver driver) {
        if (!WebDriverType.isMobile(driver)) {
            return MobilePlatform.NONE;
        }
        return this.appiumConfiguration.getTargetPlatform(driver);
    }

    public ElementLocatorFactorySelector withTimeout(int timeoutInSeconds) {
        return new ElementLocatorFactorySelector(timeoutInSeconds, this.environmentVariables);
    }
}

