/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.ConfiguredProxy;
import net.serenitybdd.core.webdriver.driverproviders.DriverArgs;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.serenitybdd.core.webdriver.driverproviders.SanitisedBrowserPreferences;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.configuration.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.AddCustomCapabilities;
import net.thucydides.core.webdriver.capabilities.BrowserPreferences;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import net.thucydides.core.webdriver.chrome.OptionsSplitter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverCapabilities
implements DriverCapabilitiesProvider {
    private static final List<String> AUTOMATION_OPTIONS = Arrays.asList("--enable-automation", "--test-type");
    private static final List<String> LIST_BASED_EXPERIMENTAL_OPTIONS = Arrays.asList("args", "extensions", "excludeSwitches", "windowTypes");
    private final EnvironmentVariables environmentVariables;
    private final String driverOptions;

    public ChromeDriverCapabilities(EnvironmentVariables environmentVariables, String driverOptions) {
        this.environmentVariables = environmentVariables;
        this.driverOptions = driverOptions;
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities((Capabilities)this.configuredOptions());
        capabilities.merge((Capabilities)W3CCapabilities.definedIn(this.environmentVariables).withPrefix("webdriver"));
        AddCustomCapabilities.startingWith("chrome.capabilities.").from(this.environmentVariables).to(capabilities);
        AddLoggingPreferences.from(this.environmentVariables).to(capabilities);
        SetProxyConfiguration.from(this.environmentVariables).in(capabilities);
        return capabilities;
    }

    public ChromeOptions configuredOptions() {
        ChromeOptions options = new ChromeOptions();
        String chromeBinary = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.CHROME_BINARY).orElse(EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_BINARY).orElse(null));
        if (chromeBinary != null) {
            String instantiatedBinaryPath = FilePathParser.forEnvironmentVariables((EnvironmentVariables)this.environmentVariables).getInstanciatedPath(chromeBinary);
            options.setBinary(instantiatedBinaryPath);
        }
        this.addEnvironmentSwitchesTo(options);
        this.addRuntimeOptionsTo(options);
        this.addPreferencesTo(options);
        this.addExperimentalOptionsTo(options);
        this.updateChromeBinaryIfSpecified(options);
        this.addProxyConfigurationTo(options);
        this.addPageLoadStrategyTo(options);
        this.addExtensionsTo(options);
        this.addUnhandledPromptBehaviour(options);
        return options;
    }

    private void addExtensionsTo(ChromeOptions options) {
        ThucydidesSystemProperty.CHROME_EXTENSION.optionalFrom(this.environmentVariables).ifPresent(extensionFile -> options.addExtensions(new File[]{new File((String)extensionFile)}));
    }

    private void addUnhandledPromptBehaviour(ChromeOptions options) {
        String unexpectedAlertBehavior = ThucydidesSystemProperty.SERENITY_DRIVER_UNEXPECTED_ALERT_BEHAVIOUR.from(this.environmentVariables);
        if (unexpectedAlertBehavior != null) {
            options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.fromString((String)unexpectedAlertBehavior));
        }
    }

    private void addPageLoadStrategyTo(ChromeOptions options) {
        String pageLoadStrategy = ThucydidesSystemProperty.SERENITY_DRIVER_PAGE_LOAD_STRATEGY.from(this.environmentVariables);
        if (pageLoadStrategy != null) {
            options.setPageLoadStrategy(PageLoadStrategy.fromString((String)pageLoadStrategy));
        }
    }

    private void addProxyConfigurationTo(ChromeOptions options) {
        ConfiguredProxy.definedIn(this.environmentVariables).ifPresent(arg_0 -> ((ChromeOptions)options).setProxy(arg_0));
    }

    private void addEnvironmentSwitchesTo(ChromeOptions options) {
        Optional headless;
        List<String> arguments = DriverArgs.fromProperty(ThucydidesSystemProperty.CHROME_SWITCHES).configuredIn(this.environmentVariables);
        if (!arguments.isEmpty()) {
            options.addArguments(arguments);
        }
        if ((headless = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.HEADLESS_MODE)).isPresent() && Boolean.parseBoolean((String)headless.get())) {
            options.addArguments(new String[]{"--headless"});
        }
    }

    private void addRuntimeOptionsTo(ChromeOptions options) {
        if (ThucydidesSystemProperty.USE_CHROME_AUTOMATION_OPTIONS.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            options.addArguments(AUTOMATION_OPTIONS);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.driverOptions)) {
            ArrayList<String> arguments = new ArrayList<String>(new OptionsSplitter().split(this.driverOptions));
            options.addArguments(arguments);
        }
        options.setAcceptInsecureCerts(ThucydidesSystemProperty.ACCEPT_INSECURE_CERTIFICATES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue());
    }

    public static Map<String, Object> preferencesConfiguredIn(EnvironmentVariables environmentVariables) {
        Map<String, Object> chromePreferences = BrowserPreferences.startingWith("chrome_preferences.").from(environmentVariables);
        chromePreferences.putAll(BrowserPreferences.startingWith("chrome.preferences.").from(environmentVariables));
        return SanitisedBrowserPreferences.cleanUpPathsIn(chromePreferences);
    }

    private void addPreferencesTo(ChromeOptions options) {
        Map<String, Object> chromePreferences = ChromeDriverCapabilities.preferencesConfiguredIn(this.environmentVariables);
        if (!chromePreferences.isEmpty()) {
            options.setExperimentalOption("prefs", chromePreferences);
        }
    }

    private void addExperimentalOptionsTo(ChromeOptions options) {
        Map<String, Object> chromeExperimentalOptions = BrowserPreferences.startingWith("chrome_experimental_options.").from(this.environmentVariables);
        chromeExperimentalOptions.putAll(BrowserPreferences.startingWith("chrome.experimental_options.").from(this.environmentVariables));
        chromeExperimentalOptions.keySet().forEach(key -> {
            Object value = chromeExperimentalOptions.get(key);
            if (LIST_BASED_EXPERIMENTAL_OPTIONS.contains(key)) {
                ArrayList<String> arguments = new ArrayList<String>(new OptionsSplitter().split((String)value));
                options.setExperimentalOption(key, arguments);
            } else {
                options.setExperimentalOption(key, value);
            }
        });
    }

    private void updateChromeBinaryIfSpecified(ChromeOptions options) {
        File executable = DriverServiceExecutable.called("chromedriver").withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).reportMissingBinary().downloadableFrom("https://sites.google.com/a/chromium.org/chromedriver/downloads").asAFile();
        if (executable != null && executable.exists()) {
            System.setProperty("webdriver.chrome.driver", executable.getAbsolutePath());
        }
    }
}

