/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.Optional;
import java.util.Properties;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.capabilities.RemoteDriverCapabilities;
import net.thucydides.core.webdriver.capabilities.RemoteTestName;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SaucelabsRemoteDriverCapabilities
implements RemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;

    public SaucelabsRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static String getSaucelabsDriverFrom(EnvironmentVariables environmentVariables) {
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SAUCELABS_BROWSERNAME).orElse(WebDriverFactory.getDriverFrom(environmentVariables));
    }

    @Override
    public String getUrl() {
        String saucelabsUrl = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SAUCELABS_URL).orElse(null);
        if (saucelabsUrl == null) {
            return null;
        }
        return this.environmentVariables.injectSystemPropertiesInto(saucelabsUrl);
    }

    @Override
    public DesiredCapabilities getCapabilities(DesiredCapabilities capabilities) {
        MutableCapabilities saucelabsCapabilities = this.saucelabsCapabilitiesDefinedIn(this.environmentVariables);
        DesiredCapabilities w3cCapabilitiesInSaucelabsSection = W3CCapabilities.definedIn(this.environmentVariables).withPrefix("saucelabs");
        this.configureBrowserAndPlatformIfDefinedInSaucelabsBlock((MutableCapabilities)w3cCapabilitiesInSaucelabsSection, (MutableCapabilities)capabilities);
        this.addBuildNumberTo(saucelabsCapabilities);
        this.configureTestName(saucelabsCapabilities);
        capabilities.setCapability("sauce:options", (Object)saucelabsCapabilities);
        capabilities.setJavascriptEnabled(true);
        return capabilities;
    }

    @NotNull
    private MutableCapabilities saucelabsCapabilitiesDefinedIn(EnvironmentVariables environmentVariables) {
        Properties saucelabsProperties = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getPropertiesWithPrefix("saucelabs.");
        MutableCapabilities sauceCaps = new MutableCapabilities();
        for (String propertyName : saucelabsProperties.stringPropertyNames()) {
            String unprefixedPropertyName = this.unprefixed(propertyName);
            sauceCaps.setCapability(unprefixedPropertyName, saucelabsProperties.getProperty(propertyName));
        }
        return sauceCaps;
    }

    private void addBuildNumberTo(MutableCapabilities capabilities) {
        if (this.environmentVariables.getProperty("BUILD_NUMBER") != null) {
            capabilities.setCapability("build", this.environmentVariables.getProperty("BUILD_NUMBER"));
        }
    }

    private void configureBrowserAndPlatformIfDefinedInSaucelabsBlock(MutableCapabilities sourceCapabilities, MutableCapabilities capabilities) {
        if (sourceCapabilities.getBrowserName() != null) {
            capabilities.setCapability("browserName", sourceCapabilities.getBrowserName());
        }
        if (sourceCapabilities.getVersion() != null) {
            capabilities.setCapability("browserVersion", sourceCapabilities.getVersion());
        }
        if (sourceCapabilities.getCapability("platformName") != null) {
            capabilities.setCapability("platformName", sourceCapabilities.getCapability("platformName"));
        }
    }

    private String unprefixed(String propertyName) {
        return propertyName.replace("saucelabs.", "");
    }

    private void configureTestName(MutableCapabilities capabilities) {
        String testName = ThucydidesSystemProperty.SAUCELABS_TEST_NAME.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)testName)) {
            capabilities.setCapability("name", testName);
        } else {
            Optional<TestOutcome> latestOutcome = StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome();
            Optional<String> guessedTestName = latestOutcome.isPresent() ? Optional.of(latestOutcome.get().getCompleteName()) : RemoteTestName.fromCurrentTest();
            guessedTestName.ifPresent(name -> capabilities.setCapability("name", name));
        }
    }
}

