/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebElementFacadeWait {
    PageObject page;
    private final long timeoutInSeconds;
    private final long sleepInMillis;

    public WebElementFacadeWait(PageObject page) {
        this.timeoutInSeconds = page.getImplicitWaitTimeout().getSeconds();
        this.sleepInMillis = 200L;
        this.page = page;
    }

    public WebElementFacadeWait(PageObject page, long timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        this.sleepInMillis = 200L;
        this.page = page;
    }

    protected WebElementFacadeWait(PageObject page, long timeoutInSeconds, long sleepInMillis) {
        this.timeoutInSeconds = timeoutInSeconds;
        this.sleepInMillis = sleepInMillis;
        this.page = page;
    }

    public WebElementFacadeWait forUpTo(long timeoutInSeconds) {
        return new WebElementFacadeWait(this.page, timeoutInSeconds, this.sleepInMillis);
    }

    public WebElementFacadeWait pollingEvery(long sleepInMillis) {
        return new WebElementFacadeWait(this.page, this.timeoutInSeconds, sleepInMillis);
    }

    public WebElementFacade until(ExpectedCondition<? extends WebElement> isTrue) {
        return this.page.element((WebElement)new WebDriverWait(this.page.getDriver(), this.timeoutInSeconds).until(isTrue));
    }
}

