/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.geometry;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Optional;
import net.thucydides.core.geometry.Point;

public class Line {
    private final Point origin;
    private final Point destination;
    private static final MathContext CONTEXT = new MathContext(2, RoundingMode.HALF_UP);

    public Line(Point origin, Point destination) {
        this.origin = origin;
        this.destination = destination;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public Point getDestination() {
        return this.destination;
    }

    public BigDecimal getSlope() {
        BigDecimal yDistance = this.destination.getY().subtract(this.origin.getY());
        BigDecimal xDistance = this.destination.getX().subtract(this.origin.getX());
        return yDistance.divide(xDistance, CONTEXT);
    }

    public BigDecimal getYIntercept() {
        BigDecimal m = this.getSlope();
        return this.origin.getY().subtract(m.multiply(this.origin.getX()));
    }

    public Optional<Point> intersectionWith(Line line) {
        if (this.parallelWith(line)) {
            return Optional.empty();
        }
        if (this.isVertical()) {
            BigDecimal b2 = line.getYIntercept();
            BigDecimal m2 = line.getSlope();
            BigDecimal y = m2.multiply(this.origin.getX()).add(b2);
            return Optional.of(Point.at(this.origin.getX(), y));
        }
        if (line.isVertical()) {
            BigDecimal b1 = this.getYIntercept();
            BigDecimal m1 = this.getSlope();
            BigDecimal y = m1.multiply(line.getOrigin().getX()).add(b1);
            return Optional.of(Point.at(line.getOrigin().getX(), y));
        }
        BigDecimal m1 = this.getSlope();
        BigDecimal m2 = line.getSlope();
        BigDecimal b1 = this.getYIntercept();
        BigDecimal b2 = line.getYIntercept();
        BigDecimal x = b2.subtract(b1).divide(m1.subtract(m2), CONTEXT);
        BigDecimal y = m1.multiply(x).add(b1);
        return Optional.of(Point.at(x, y));
    }

    private boolean parallelWith(Line line) {
        if (this.isVertical() && line.isVertical()) {
            return true;
        }
        if (!this.isVertical() && !line.isVertical()) {
            return this.getSlope().equals(line.getSlope());
        }
        return false;
    }

    private boolean isVertical() {
        return this.destination.getX().subtract(this.origin.getX()).equals(BigDecimal.ZERO);
    }

    public static LineBuilder from(Point origin) {
        return new LineBuilder(origin);
    }

    public String toString() {
        return this.origin + "->" + this.destination;
    }

    public static class LineBuilder {
        private final Point origin;
        private boolean preferHorizontalLineForSinglePoint = true;

        public LineBuilder(Point origin) {
            this.origin = origin;
        }

        public Line to(Point destination) {
            if (!this.origin.equals(destination)) {
                return new Line(this.origin, destination);
            }
            return new Line(this.origin, this.extended(destination));
        }

        private Point extended(Point destination) {
            if (this.preferHorizontalLineForSinglePoint) {
                return Point.at(destination.getX().add(BigDecimal.ONE), destination.getY());
            }
            return Point.at(destination.getX(), destination.getY().add(BigDecimal.ONE));
        }

        public LineBuilder horizontally() {
            this.preferHorizontalLineForSinglePoint = true;
            return this;
        }

        public LineBuilder vertically() {
            this.preferHorizontalLineForSinglePoint = false;
            return this;
        }
    }
}

