/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.FirefoxOptionsEnhancer;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverCapabilities;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.GeckoServicePool;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirefoxDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(FirefoxDriverProvider.class);
    private final DriverServicePool driverServicePool = new GeckoServicePool();
    private final FixtureProviderService fixtureProviderService;

    private DriverServicePool getDriverServicePool() throws IOException {
        this.driverServicePool.ensureServiceIsRunning();
        return this.driverServicePool;
    }

    protected String serviceName() {
        return "firefox";
    }

    public FirefoxDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        MutableCapabilities capabilities = new FirefoxDriverCapabilities(environmentVariables).getCapabilities();
        WebDriver driver = this.shouldUseGeckoDriver(environmentVariables) ? this.newMarionetteDriver(capabilities, environmentVariables) : this.newFirefoxDriver(capabilities, environmentVariables);
        this.driverProperties.registerCapabilities("firefox", this.capabilitiesToProperties((Capabilities)capabilities));
        return driver;
    }

    private boolean shouldUseGeckoDriver(EnvironmentVariables environmentVariables) {
        return (this.geckoDriverIsInEnvironmentVariable(environmentVariables) || this.geckoDriverIsOnTheClasspath()) && this.geckoIsNotDisabled(environmentVariables);
    }

    private boolean geckoIsNotDisabled(EnvironmentVariables environmentVariables) {
        return ThucydidesSystemProperty.USE_GECKO_DRIVER.booleanFrom(environmentVariables, Boolean.valueOf(true));
    }

    private WebDriver newFirefoxDriver(MutableCapabilities capabilities, EnvironmentVariables environmentVariables) {
        capabilities.setCapability("marionette", false);
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        FirefoxOptions options = new FirefoxOptions((Capabilities)enhancer.enhanced(capabilities, SupportedWebDriver.FIREFOX));
        FirefoxOptionsEnhancer.enhanceOptions(options).using(environmentVariables);
        return new FirefoxDriver(options);
    }

    private WebDriver newMarionetteDriver(MutableCapabilities capabilities, EnvironmentVariables environmentVariables) {
        capabilities.setCapability("marionette", true);
        capabilities.setCapability("headless", (Object)ThucydidesSystemProperty.HEADLESS_MODE.booleanFrom(environmentVariables, Boolean.valueOf(false)));
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        try {
            return this.getDriverServicePool().newDriver((Capabilities)enhancer.enhanced(capabilities, SupportedWebDriver.FIREFOX));
        }
        catch (IOException couldNotStartGeckoDriverService) {
            LOGGER.warn("Failed to start the gecko driver service, using a native driver instead", (Object)couldNotStartGeckoDriverService.getMessage());
            return this.newFirefoxDriver(capabilities, environmentVariables);
        }
    }

    private boolean geckoDriverIsOnTheClasspath() {
        try {
            Runtime.getRuntime().exec("geckodriver --help");
            return true;
        }
        catch (Exception geckodriverBinaryNotFound) {
            try {
                Runtime.getRuntime().exec("wires --help");
                return true;
            }
            catch (Exception wiresBinaryNotFound) {
                return false;
            }
        }
    }

    private boolean geckoDriverIsInEnvironmentVariable(EnvironmentVariables environmentVariables) {
        try {
            new ProcessBuilder(new String[0]).command(ThucydidesSystemProperty.WEBDRIVER_GECKO_DRIVER.from(environmentVariables), "--help").start();
            return true;
        }
        catch (Exception geckodriverBinaryNotFound) {
            return false;
        }
    }
}

