/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.ChromeDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.servicepools.ChromeServicePool;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeDriverProvider.class);
    private final DriverServicePool driverServicePool = new ChromeServicePool();
    private final FixtureProviderService fixtureProviderService;

    private DriverServicePool getDriverServicePool() throws IOException {
        this.driverServicePool.ensureServiceIsRunning();
        return this.driverServicePool;
    }

    public ChromeDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        MutableCapabilities capabilities = this.requestedChromeCapabilities(options, environmentVariables);
        this.driverProperties.registerCapabilities("chrome", this.capabilitiesToProperties((Capabilities)capabilities));
        try {
            return this.getDriverServicePool().newDriver((Capabilities)capabilities);
        }
        catch (IOException couldNotStartChromeServer) {
            LOGGER.warn("Failed to start the chrome driver service, using a native driver instead", (Object)couldNotStartChromeServer.getMessage());
            CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
            return new ChromeDriver((Capabilities)enhancer.enhanced(capabilities, SupportedWebDriver.CHROME));
        }
    }

    private MutableCapabilities requestedChromeCapabilities(String options, EnvironmentVariables environmentVariables) {
        MutableCapabilities capabilities = new ChromeDriverCapabilities(environmentVariables, options).getCapabilities();
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        return enhancer.enhanced(capabilities, SupportedWebDriver.CHROME);
    }
}

