/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.eventbus.Subscribe;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.net.URL;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.appium.AppiumDevicePool;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.events.TestLifecycleEvents;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverInstanceEventListener;
import net.thucydides.core.webdriver.WebDriverInstanceEvents;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;

public class AppiumDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public AppiumDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        EnvironmentVariables testEnvironmentVariables = environmentVariables.copy();
        String deviceName = AppiumDevicePool.instance(testEnvironmentVariables).requestDevice();
        testEnvironmentVariables.setProperty(ThucydidesSystemProperty.APPIUM_DEVICE_NAME.getPropertyName(), deviceName);
        testEnvironmentVariables.clearProperty(ThucydidesSystemProperty.APPIUM_DEVICE_NAMES.getPropertyName());
        CapabilityEnhancer enhancer = new CapabilityEnhancer(testEnvironmentVariables, this.fixtureProviderService);
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        switch (this.appiumTargetPlatform(testEnvironmentVariables)) {
            case ANDROID: {
                AndroidDriver androidDriver = new AndroidDriver(this.appiumUrl(testEnvironmentVariables), (Capabilities)enhancer.enhanced(this.appiumCapabilities(options, testEnvironmentVariables), SupportedWebDriver.ANDROID));
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(androidDriver.getCapabilities()));
                WebDriverInstanceEvents.bus().register(this.listenerFor((WebDriver)androidDriver, deviceName));
                return androidDriver;
            }
            case IOS: {
                IOSDriver iosDriver = new IOSDriver(this.appiumUrl(testEnvironmentVariables), (Capabilities)enhancer.enhanced(this.appiumCapabilities(options, testEnvironmentVariables), SupportedWebDriver.IPHONE));
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(iosDriver.getCapabilities()));
                WebDriverInstanceEvents.bus().register(this.listenerFor((WebDriver)iosDriver, deviceName));
                return iosDriver;
            }
        }
        throw new UnsupportedDriverException(this.appiumTargetPlatform(testEnvironmentVariables).name());
    }

    private MutableCapabilities appiumCapabilities(String options, EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getCapabilities(options);
    }

    private MobilePlatform appiumTargetPlatform(EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getTargetPlatform();
    }

    private URL appiumUrl(EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getUrl();
    }

    private WebDriverInstanceEventListener listenerFor(WebDriver driver, String deviceName) {
        return new AppiumEventListener(driver, deviceName);
    }

    private static class AppiumEventListener
    implements WebDriverInstanceEventListener {
        private final String deviceName;
        private WebDriver appiumDriver;
        private AppiumDevicePool devicePool;
        private Thread currentThread;

        private AppiumEventListener(WebDriver appiumDriver, String deviceName, AppiumDevicePool devicePool) {
            this.appiumDriver = appiumDriver;
            this.deviceName = deviceName;
            this.devicePool = devicePool;
            this.currentThread = Thread.currentThread();
            TestLifecycleEvents.register(this);
        }

        @Subscribe
        public void testFinishes(TestLifecycleEvents.TestFinished testFinished) {
            this.releaseAllDevicesUsedInThread(Thread.currentThread());
        }

        private AppiumEventListener(WebDriver appiumDriver, String deviceName) {
            this(appiumDriver, deviceName, AppiumDevicePool.instance());
        }

        @Override
        public void close(WebDriver driver) {
            this.quit(driver);
        }

        @Override
        public void quit(WebDriver driver) {
            if (this.appiumDriver == driver) {
                this.devicePool.freeDevice(this.deviceName);
                this.appiumDriver = null;
            }
        }

        void releaseAllDevicesUsedInThread(Thread thread) {
            if (this.appiumDriver != null && this.currentThread == thread) {
                this.devicePool.freeDevice(this.deviceName);
                this.appiumDriver = null;
            }
        }
    }
}

