/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.appium;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.serenitybdd.core.buildinfo.PropertyBasedDriverCapabilityRecord;
import net.serenitybdd.core.webdriver.appium.NoAvailableDeviceException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumDevicePool {
    Logger LOGGER = LoggerFactory.getLogger(PropertyBasedDriverCapabilityRecord.class);
    private final List<String> deviceList;
    private final List<String> availableDevices;
    private static AppiumDevicePool pool;

    public static AppiumDevicePool instance(EnvironmentVariables environmentVariables) {
        if (pool == null) {
            pool = new AppiumDevicePool(environmentVariables);
        }
        return pool;
    }

    public static AppiumDevicePool instance() {
        if (pool == null) {
            pool = new AppiumDevicePool((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
        }
        return pool;
    }

    public static void clear() {
        pool = null;
    }

    public AppiumDevicePool(EnvironmentVariables environmentVariables) {
        List<String> specifiedDevices = this.elementsIn(ThucydidesSystemProperty.APPIUM_DEVICE_NAMES.from(environmentVariables, ""));
        String definedDevice = ThucydidesSystemProperty.APPIUM_DEVICE_NAME.from(environmentVariables);
        this.deviceList = specifiedDevices.isEmpty() ? this.deviceListFromSingleDevice(definedDevice) : this.elementsIn(ThucydidesSystemProperty.APPIUM_DEVICE_NAMES.from(environmentVariables, ""));
        this.availableDevices = Collections.synchronizedList(new ArrayList<String>(this.deviceList));
        this.LOGGER.info("Appium Device Pool initialised with devices: " + this.deviceList);
    }

    private List<String> deviceListFromSingleDevice(String definedDevice) {
        return definedDevice == null ? new ArrayList() : Collections.singletonList(definedDevice);
    }

    public List<String> getAvailableDevices() {
        return new ArrayList<String>(this.availableDevices);
    }

    private List<String> elementsIn(String list) {
        return Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)list);
    }

    public synchronized void freeDevice(String deviceName) {
        this.LOGGER.info("Device freed: " + this.deviceList);
        this.availableDevices.add(deviceName);
    }

    public synchronized String requestDevice() {
        if (this.availableDevices.isEmpty()) {
            throw new NoAvailableDeviceException("No available Appium device found - have you specified a device in appium.deviceName or a list of available devices in appium.deviceNames?");
        }
        String providedDevice = this.availableDevices.remove(0);
        this.LOGGER.info("Device provided: " + providedDevice);
        return providedDevice;
    }
}

