/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.redimension;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.redimension.MaximizeRedimensioner;
import net.thucydides.core.webdriver.redimension.NoopRedimensioner;
import net.thucydides.core.webdriver.redimension.RedimensionStrategy;
import net.thucydides.core.webdriver.redimension.Redimensioner;
import net.thucydides.core.webdriver.redimension.ResizeRedimensioner;
import org.openqa.selenium.WebDriver;

public class RedimensionBrowser {
    private final EnvironmentVariables environmentVariables;

    public RedimensionBrowser(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private Map<RedimensionStrategy, Redimensioner> getRedimensionerStrategies() {
        return ImmutableMap.of((Object)((Object)RedimensionStrategy.DoNotRedimension), (Object)new NoopRedimensioner(), (Object)((Object)RedimensionStrategy.RedimensionToSpecifiedSize), (Object)new ResizeRedimensioner(this.environmentVariables), (Object)((Object)RedimensionStrategy.Maximize), (Object)new MaximizeRedimensioner());
    }

    public void withDriver(WebDriver driver) {
        RedimensionStrategy strategy = RedimensionStrategy.strategyFor(driver, this.environmentVariables);
        this.getRedimensionerStrategies().get((Object)strategy).redimension(driver);
    }
}

