/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.tags;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.tags.Taggable;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.RunWith;

public class TagScanner {
    private final List<TestTag> providedTags;

    public TagScanner(EnvironmentVariables environmentVariables) {
        this.providedTags = this.tagsProvidedBy(environmentVariables);
    }

    public boolean shouldRunForTags(List<String> tags) {
        if (this.providedTags.isEmpty()) {
            return true;
        }
        return this.tagsMatchAPositiveTag(tags, this.providedTags) && !this.tagsMatchANegativeTag(tags, this.providedTags);
    }

    public boolean shouldRunClass(Class<?> testClass) {
        if (this.providedTags.isEmpty()) {
            return true;
        }
        return this.testClassMatchesAPositiveTag(testClass, this.providedTags) && this.testClassDoesNotMatchANegativeTag(testClass, this.providedTags);
    }

    public boolean shouldRunMethod(Class<?> testClass, String methodName) {
        if (!this.isATaggable(testClass) || this.providedTags.isEmpty()) {
            return true;
        }
        return this.testMethodMatchesAPositiveTag(testClass, methodName, this.providedTags) && this.testMethodDoesNotMatchANegativeTag(testClass, methodName, this.providedTags);
    }

    private boolean isATaggable(Class<?> testClass) {
        RunWith runWith = testClass.getAnnotation(RunWith.class);
        return runWith != null && Taggable.class.isAssignableFrom(runWith.value());
    }

    private boolean testClassMatchesAPositiveTag(Class<?> testClass, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTags();
        return this.containsAPositiveMatch(expectedTags, tags);
    }

    private boolean tagsMatchAPositiveTag(List<String> tagValues, List<TestTag> expectedTags) {
        List<TestTag> tags = this.definedIn(tagValues);
        return this.containsAPositiveMatch(expectedTags, tags);
    }

    private boolean tagsMatchANegativeTag(List<String> tagValues, List<TestTag> expectedTags) {
        List<TestTag> tags = this.definedIn(tagValues);
        return this.containsANegativeMatch(expectedTags, tags);
    }

    private List<TestTag> definedIn(List<String> tagValues) {
        return tagValues.stream().map(TestTag::withValue).collect(Collectors.toList());
    }

    private boolean containsAPositiveMatch(List<TestTag> expectedTags, List<TestTag> tags) {
        return this.positive(expectedTags).isEmpty() || this.tagsMatch(this.positive(expectedTags), tags);
    }

    private boolean testClassDoesNotMatchANegativeTag(Class<?> testClass, List<TestTag> negatedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTags();
        return !this.containsANegativeMatch(negatedTags, tags);
    }

    private List<TestTag> positive(List<TestTag> tags) {
        ArrayList<TestTag> positiveTags = new ArrayList<TestTag>();
        for (TestTag tag : tags) {
            if (this.isANegative(tag)) continue;
            positiveTags.add(tag);
        }
        return positiveTags;
    }

    private boolean isANegative(TestTag tag) {
        return tag.getType().startsWith("~");
    }

    private List<TestTag> negative(List<TestTag> tags) {
        ArrayList<TestTag> negativeTags = new ArrayList<TestTag>();
        for (TestTag tag : tags) {
            if (!this.isANegative(tag)) continue;
            negativeTags.add(TestTag.withName(tag.getName()).andType(tag.getType().substring(1)));
        }
        return negativeTags;
    }

    private boolean testMethodMatchesAPositiveTag(Class<?> testClass, String methodName, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTagsForMethod(methodName);
        return this.containsAPositiveMatch(expectedTags, tags);
    }

    private boolean testMethodDoesNotMatchANegativeTag(Class<?> testClass, String methodName, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTagsForMethod(methodName);
        return !this.containsANegativeMatch(expectedTags, tags);
    }

    private boolean containsANegativeMatch(List<TestTag> expectedTags, List<TestTag> tags) {
        if (this.negative(expectedTags).isEmpty()) {
            return false;
        }
        return this.tagsMatch(this.negative(expectedTags), tags);
    }

    private boolean tagsMatch(List<TestTag> expectedTags, List<TestTag> tags) {
        for (TestTag expectedTag : expectedTags) {
            if (!tags.contains(expectedTag)) continue;
            return true;
        }
        return false;
    }

    private List<TestTag> tagsProvidedBy(EnvironmentVariables environmentVariables) {
        String tagListValue = environmentVariables.getProperty(ThucydidesSystemProperty.TAGS);
        if (StringUtils.isNotEmpty((CharSequence)tagListValue)) {
            List tagList = Splitter.on((String)",").trimResults().splitToList((CharSequence)tagListValue);
            return tagList.stream().map(TestTag::withValue).collect(Collectors.toList());
        }
        return new ArrayList<TestTag>();
    }
}

