/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import net.thucydides.core.annotations.Fields;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;

public class ReplaceField {
    private final String stepDescription;
    private final String field;

    public ReplaceField(String stepDescription, String field) {
        this.stepDescription = stepDescription;
        this.field = field;
    }

    public static ReplaceFieldBuilder in(String stepDescription) {
        return new ReplaceFieldBuilder(stepDescription);
    }

    public String with(Object value) {
        String fieldName = this.fieldNameFor(this.field);
        if (this.stepDescription.contains(fieldName) && value != Fields.FieldValue.UNDEFINED) {
            return StringUtils.replace((String)this.stepDescription, (String)this.fieldNameFor(this.field), (String)this.stringValueFor(value));
        }
        return this.stepDescription;
    }

    private String fieldNameFor(String field) {
        return "#" + field;
    }

    private String stringValueFor(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Keys[]) {
            return this.keyNamesFor((Keys[])value);
        }
        if (value.getClass().isArray()) {
            return Joiner.on((String)",").join(Collections.singletonList(value));
        }
        return value.toString();
    }

    private String keyNamesFor(Keys[] keyValues) {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Keys keyValue : keyValues) {
            keyNames.add(keyValue.name());
        }
        return Joiner.on((String)",").join(keyNames);
    }

    public static class ReplaceFieldBuilder {
        private String stepDescription;

        public ReplaceFieldBuilder(String stepDescription) {
            this.stepDescription = stepDescription;
        }

        public ReplaceField theFieldCalled(String field) {
            return new ReplaceField(this.stepDescription, field);
        }
    }
}

