/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Splitter;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;

public class ReportOptions {
    private final boolean showStepDetails;
    private final boolean showManualTests;
    private final boolean showReleases;
    private final boolean showProgress;
    private final boolean showHistory;
    private final boolean showTagMenus;
    private final boolean showRelatedTags;
    private final String projectName;
    private final RequirementsService requirementsService;
    private final boolean displayPiechart;
    private final List<String> firstClassTagTypes;

    public ReportOptions(EnvironmentVariables environmentVariables) {
        this(environmentVariables, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public ReportOptions(EnvironmentVariables environmentVariables, RequirementsService requirementsService) {
        this.showStepDetails = Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_REPORTS_SHOW_STEP_DETAILS.from(environmentVariables, "false"));
        this.showManualTests = Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_REPORT_SHOW_MANUAL_TESTS.from(environmentVariables, "true"));
        this.showReleases = Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_REPORT_SHOW_RELEASES.from(environmentVariables, "true"));
        this.showProgress = Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_REPORT_SHOW_PROGRESS.from(environmentVariables, "false"));
        this.showHistory = Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_REPORT_SHOW_HISTORY.from(environmentVariables, "false"));
        this.showTagMenus = Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_REPORT_SHOW_TAG_MENUS.from(environmentVariables, "false"));
        this.showRelatedTags = Boolean.valueOf(ThucydidesSystemProperty.SHOW_RELATED_TAGS.from(environmentVariables, "true"));
        this.displayPiechart = Boolean.valueOf(ThucydidesSystemProperty.SHOW_PIE_CHARTS.from(environmentVariables, "true"));
        this.projectName = ThucydidesSystemProperty.SERENITY_PROJECT_NAME.from(environmentVariables, "");
        this.requirementsService = requirementsService;
        this.firstClassTagTypes = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)ThucydidesSystemProperty.THUCYDIDES_REPORT_TAG_MENUS.from(environmentVariables, ""));
    }

    public List<String> getFirstClassTagTypes() {
        return this.firstClassTagTypes;
    }

    public boolean isShowStepDetails() {
        return this.showStepDetails;
    }

    public boolean isShowManualTests() {
        return this.showManualTests;
    }

    public boolean isShowReleases() {
        return this.showReleases && !this.requirementsService.getReleasesFromRequirements().isEmpty();
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public boolean isShowHistory() {
        return this.showHistory;
    }

    public boolean isShowTagMenus() {
        return this.showTagMenus;
    }

    public boolean isShowRelatedTags() {
        return this.showRelatedTags;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isDisplayPiechart() {
        return this.displayPiechart;
    }
}

