/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import ch.lambdaj.Lambda;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AddCustomCapabilities {
    private final String prefix;
    private EnvironmentVariables environmentVariables;

    public AddCustomCapabilities(String prefix) {
        this.prefix = prefix;
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    public static AddCustomCapabilities startingWith(String prefix) {
        return new AddCustomCapabilities(prefix);
    }

    public AddCustomCapabilities from(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public void to(DesiredCapabilities capabilities) {
        List browserStackProperties = Lambda.filter((Matcher)Lambda.having((Object)Lambda.on(String.class), (Matcher)Matchers.startsWith((String)"browserstack.")), this.environmentVariables.getKeys());
        for (String propertyKey : browserStackProperties) {
            String preparedPropertyKey = this.getPreparedPropertyKey(propertyKey);
            String propertyValue = this.environmentVariables.getProperty(propertyKey);
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            capabilities.setCapability(preparedPropertyKey, propertyValue);
            capabilities.setCapability(propertyKey, propertyValue);
        }
    }

    private String getPreparedPropertyKey(String propertyKey) {
        String shortenedPropertyKey = propertyKey.replace(this.prefix + ".", "");
        if (shortenedPropertyKey.equals("os.version")) {
            return "os_version";
        }
        if (shortenedPropertyKey.equals("browser.version")) {
            return "browser_version";
        }
        return shortenedPropertyKey;
    }
}

