/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.construction;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.Pages;

public class StepLibraryType {
    private final Class<?> stepLibraryClass;

    public StepLibraryType(Class<?> stepLibraryClass) {
        this.stepLibraryClass = stepLibraryClass;
    }

    public static StepLibraryType ofClass(Class<?> stepLibraryClass) {
        return new StepLibraryType(stepLibraryClass);
    }

    public <T> boolean hasAPagesConstructor() {
        ImmutableSet constructors = ImmutableSet.copyOf((Object[])this.stepLibraryClass.getDeclaredConstructors());
        return Iterables.any((Iterable)constructors, this.withASinglePagesParameter());
    }

    public <T> boolean hasAConstructorWithParameters() {
        ImmutableSet constructors = ImmutableSet.copyOf((Object[])this.stepLibraryClass.getDeclaredConstructors());
        return Iterables.any((Iterable)constructors, this.withAnyParameters());
    }

    public <T> boolean hasAPagesField() {
        ImmutableSet fields = ImmutableSet.copyOf(Fields.of(this.stepLibraryClass).allFields());
        return Iterables.any((Iterable)fields, StepLibraryType.ofTypePages());
    }

    private Predicate<Constructor<?>> withAnyParameters() {
        return new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length > 0;
            }

            public boolean test(@Nullable Constructor<?> input) {
                return this.apply(input);
            }
        };
    }

    private Predicate<Constructor<?>> withASinglePagesParameter() {
        return new Predicate<Constructor<?>>(){

            public boolean apply(@Nullable Constructor<?> constructor) {
                return constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Pages.class;
            }

            public boolean test(@Nullable Constructor<?> input) {
                return this.apply(input);
            }
        };
    }

    public static Predicate<Field> ofTypePages() {
        return new Predicate<Field>(){

            public boolean apply(@Nullable Field input) {
                return input.getType() == Pages.class;
            }

            public boolean test(@Nullable Field input) {
                return this.apply(input);
            }
        };
    }
}

