/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.core.pages.PageObject;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.Pages;

public class PageObjectDependencyInjector
implements DependencyInjector {
    private final Pages pages;
    EnvironmentDependencyInjector environmentDependencyInjector;

    public PageObjectDependencyInjector(Pages pages) {
        this.pages = pages;
        this.environmentDependencyInjector = new EnvironmentDependencyInjector();
    }

    @Override
    public void injectDependenciesInto(Object target) {
        this.environmentDependencyInjector.injectDependenciesInto(target);
        List<Field> pageObjectFields = this.pageObjectFieldsIn(target);
        this.updatePageObject(target, this.pages);
        for (Field pageObjectField : this.nonAbstract(pageObjectFields)) {
            this.instantiatePageObjectIfNotAssigned(pageObjectField, target);
        }
    }

    private List<Field> nonAbstract(List<Field> pageObjectFields) {
        ArrayList concretePageObjectFields = Lists.newArrayList();
        for (Field field : pageObjectFields) {
            if (Modifier.isAbstract(field.getType().getModifiers())) continue;
            concretePageObjectFields.add(field);
        }
        return concretePageObjectFields;
    }

    @Override
    public void reset() {
    }

    private void instantiatePageObjectIfNotAssigned(Field pageObjectField, Object target) {
        try {
            pageObjectField.setAccessible(true);
            if (pageObjectField.get(target) == null) {
                Class<?> pageObjectClass = pageObjectField.getType();
                Object newPageObject = this.pages.getPage(pageObjectClass);
                this.injectDependenciesInto(newPageObject);
                pageObjectField.set(target, newPageObject);
            } else {
                this.updatePageObject(pageObjectField.get(target), this.pages);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate page objects in " + target);
        }
    }

    private void updatePageObject(Object pageObject, Pages pages) {
        if (pageObject instanceof PageObject) {
            ((PageObject)pageObject).setPages(pages);
            ((PageObject)pageObject).setDriver(pages.getDriver());
        }
    }

    private List<Field> pageObjectFieldsIn(Object target) {
        Set<Field> allFields = Fields.of(target.getClass()).allFields();
        ArrayList pageObjectFields = Lists.newArrayList();
        for (Field field : allFields) {
            if (!PageObject.class.isAssignableFrom(field.getType())) continue;
            pageObjectFields.add(field);
        }
        return pageObjectFields;
    }
}

