/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.cglib.proxy.MethodProxy;
import net.thucydides.core.steps.BaseMethodRunner;
import net.thucydides.core.steps.DefaultValue;
import net.thucydides.core.steps.MethodRunner;

class DryRunMethodRunner
extends BaseMethodRunner
implements MethodRunner {
    private final List<String> slowDomains = ImmutableList.of((Object)"webdriver", (Object)"rest");

    DryRunMethodRunner() {
    }

    @Override
    public Object invokeMethodAndNotifyFailures(Object obj, Method method, Object[] args, MethodProxy proxy, Object result) throws Throwable {
        try {
            if (!this.isSlow(method)) {
                result = this.invokeMethod(obj, args, proxy);
            }
        }
        catch (Throwable ignorableException) {
            return DefaultValue.defaultReturnValueFor(method, obj);
        }
        return result;
    }

    private boolean isSlow(Method method) {
        for (String slowDomain : this.slowDomains) {
            if (!method.getDeclaringClass().getPackage().toString().contains(slowDomain)) continue;
            return true;
        }
        return false;
    }
}

