/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import net.thucydides.core.requirements.PathStartsWith;
import org.apache.commons.collections.IteratorUtils;

public class RequirementsPath {
    private static final Pattern PATH_SEPARATORS = Pattern.compile("[\\\\/.]");
    private static final Pattern FILE_SYSTEM_PATH_SEPARATORS = Pattern.compile("[\\\\/]");

    public static List<String> stripRootFromPath(String root, List<String> storyPathElements) {
        List<String> rootElements = RequirementsPath.pathElements(root);
        if (RequirementsPath.thePathIn(storyPathElements).startsWith(rootElements)) {
            return storyPathElements.subList(rootElements.size(), storyPathElements.size());
        }
        return storyPathElements;
    }

    private static PathStartsWith thePathIn(List<String> storyPathElements) {
        return new PathStartsWith(storyPathElements);
    }

    public static List<String> pathElements(String path) {
        if (path == null) {
            return Lists.newArrayList();
        }
        return IteratorUtils.toList(Splitter.on((Pattern)PATH_SEPARATORS).omitEmptyStrings().trimResults().split((CharSequence)path).iterator());
    }

    public static List<String> fileSystemPathElements(String path) {
        if (path == null) {
            return Lists.newArrayList();
        }
        return IteratorUtils.toList(Splitter.on((Pattern)FILE_SYSTEM_PATH_SEPARATORS).omitEmptyStrings().trimResults().split((CharSequence)path).iterator());
    }
}

