/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.screenshots;

import net.thucydides.core.model.ErrorMessageFormatter;
import net.thucydides.core.model.stacktrace.FailureCause;
import org.apache.commons.lang3.StringEscapeUtils;

public class Screenshot {
    private final String filename;
    private final String description;
    private final int width;
    private final FailureCause error;

    public Screenshot(String filename, String description, int width, FailureCause error) {
        this.filename = filename;
        this.description = description;
        this.width = width;
        this.error = error;
    }

    public Screenshot(String filename, String description, int width) {
        this(filename, description, width, null);
    }

    public FailureCause getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error != null ? this.error.getMessage() : "";
    }

    public String getShortErrorMessage() {
        return new ErrorMessageFormatter(this.getErrorMessage()).getShortErrorMessage();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWidth() {
        return this.width;
    }

    public HtmlFormattedInfo getHtml() {
        return new HtmlFormattedInfo(this.description);
    }

    public static class HtmlFormattedInfo {
        private final String description;

        public HtmlFormattedInfo(String description) {
            this.description = description;
        }

        public String getDescription() {
            return StringEscapeUtils.escapeHtml4((String)this.description);
        }
    }
}

