/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TestTag
implements Comparable<TestTag> {
    public static final TestTag EMPTY_TAG = new TestTag("", "");
    private final String name;
    private final String type;
    private transient String normalisedName;
    private transient String normalisedType;

    private TestTag(String name, String type) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.type = type;
    }

    public String normalisedName() {
        if (this.normalisedName == null) {
            this.normalisedName = this.name.toLowerCase();
        }
        return this.normalisedName;
    }

    public String normalisedType() {
        if (this.normalisedType == null) {
            this.normalisedType = this.type.toLowerCase();
        }
        return this.normalisedType;
    }

    public String getCompleteName() {
        if (StringUtils.isEmpty((CharSequence)this.name) && StringUtils.isEmpty((CharSequence)this.type)) {
            return "";
        }
        return Joiner.on((String)"_").join((Object)this.normalisedType(), (Object)this.normalisedName(), new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getShortName() {
        return this.name.contains("/") ? this.name.substring(this.name.indexOf("/") + 1) : this.name;
    }

    public static TestTagBuilder withName(String tagName) {
        return new TestTagBuilder(tagName);
    }

    public static TestTag withValue(String value) {
        if (value.contains(":")) {
            return TestTag.getTestTag(value, value.indexOf(":"));
        }
        if (value.contains("=")) {
            return TestTag.getTestTag(value, value.indexOf("="));
        }
        return TestTag.withName(value.trim()).andType("tag");
    }

    private static TestTag getTestTag(String value, int separatorPosition) {
        String type = value.substring(0, separatorPosition).trim();
        String name = value.substring(separatorPosition + 1).trim();
        return TestTag.withName(name).andType(type);
    }

    @Override
    public int compareTo(TestTag otherTag) {
        int typeComparison = ObjectUtils.compare((Comparable)((Object)this.getType()), (Comparable)((Object)otherTag.getType()));
        if (typeComparison != 0) {
            return typeComparison;
        }
        return this.getName().compareToIgnoreCase(otherTag.getName());
    }

    public boolean isAsOrMoreSpecificThan(TestTag testTag) {
        if (this.equals(testTag)) {
            return true;
        }
        return this.normalisedName().endsWith("/" + testTag.normalisedName()) && this.getType().equals(testTag.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestTag testTag = (TestTag)o;
        if (!this.normalisedName().equals(testTag.normalisedName())) {
            return false;
        }
        return this.normalisedType().equals(testTag.normalisedType());
    }

    public int hashCode() {
        int result = this.normalisedName().hashCode();
        result = 31 * result + this.normalisedType().hashCode();
        return result;
    }

    public String toString() {
        return "TestTag{name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
    }

    public static class TestTagBuilder {
        private final String name;

        public TestTagBuilder(String name) {
            this.name = name;
        }

        public TestTag andType(String type) {
            return new TestTag(this.name, this.withoutTagSymbol(type));
        }

        private String withoutTagSymbol(String type) {
            return type.startsWith("@") ? type.substring(1) : type;
        }
    }
}

