/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultComparison;

public class DataTableRow {
    private List<? extends Object> values;
    private TestResult result;

    public DataTableRow(List<? extends Object> values) {
        this(values, TestResult.UNDEFINED);
    }

    public DataTableRow(List<? extends Object> values, TestResult result) {
        this.values = new ArrayList<Object>(values);
        this.result = result;
    }

    public List<? extends Object> getValues() {
        return new ArrayList<Object>(this.values);
    }

    public List<String> getStringValues() {
        return Lists.transform(this.values, (Function)new Function<Object, String>(){

            public String apply(Object o) {
                return o == null ? "" : o.toString();
            }
        });
    }

    public TestResult getResult() {
        return this.result;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void updateResult(TestResult newResult) {
        if (newResult == TestResult.UNDEFINED) {
            this.setResult(newResult);
        } else {
            this.setResult(TestResultComparison.overallResultFor(this.result, newResult));
        }
    }

    public String toString() {
        return "DataTableRow{values=" + this.values + ", result=" + (Object)((Object)this.result) + '}';
    }
}

