/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.buildinfo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.thucydides.core.webdriver.Configuration;
import org.openqa.selenium.Capabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBasedDriverCapabilityRecord
implements DriverCapabilityRecord {
    Logger LOGGER = LoggerFactory.getLogger(PropertyBasedDriverCapabilityRecord.class);
    private Configuration configuration;

    @Inject
    public PropertyBasedDriverCapabilityRecord(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void registerCapabilities(String driver, Capabilities capabilities) {
        Properties properties = new Properties();
        properties.setProperty("platform", capabilities.getPlatform().name());
        for (String capability : capabilities.asMap().keySet()) {
            if (!(capabilities.getCapability(capability) instanceof String)) continue;
            properties.setProperty(capability, capabilities.getCapability(capability).toString());
        }
        try {
            File browserProperties = new File(this.configuration.getOutputDirectory(), "browser-" + driver.toLowerCase() + ".properties");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(browserProperties), StandardCharsets.UTF_8.toString());){
                properties.store(writer, "");
            }
        }
        catch (IOException e) {
            this.LOGGER.warn("Failed to store browser configuration for " + capabilities);
        }
    }

    @Override
    public List<String> getDrivers() {
        ArrayList drivers = Lists.newArrayList();
        try (DirectoryStream<Path> stream = this.driverCapabilityRecords();){
            for (Path file : stream) {
                String driverName = this.driverNameFrom(file);
                drivers.add(driverName);
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            this.LOGGER.error("Exception during getting drivers", (Throwable)x);
        }
        return drivers;
    }

    private String driverNameFrom(Path file) {
        return file.getFileName().toString().replace("browser-", "").replace(".properties", "");
    }

    private DirectoryStream<Path> driverCapabilityRecords() throws IOException {
        Path outputDirectory = this.configuration.getOutputDirectory().toPath();
        return Files.newDirectoryStream(outputDirectory, "browser-*.properties");
    }

    @Override
    public Map<String, Properties> getDriverCapabilities() {
        HashMap driverCapabilities = Maps.newHashMap();
        try (DirectoryStream<Path> stream = this.driverCapabilityRecords();){
            for (Path file : stream) {
                String driverName = this.driverNameFrom(file);
                Properties driverProperties = new Properties();
                try (InputStream properties = Files.newInputStream(file, new OpenOption[0]);){
                    driverProperties.load(properties);
                }
                driverCapabilities.put(driverName, driverProperties);
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            this.LOGGER.error("Exception during getting driver capabilities", (Throwable)x);
        }
        return driverCapabilities;
    }
}

