/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.thucydides.core.steps.StepArgumentWriter;

public class ReadableMethodName {
    public static TestNameBuilder forMethod(Method method) {
        return new TestNameBuilder(method);
    }

    public static class TestNameBuilder {
        Method method;
        Object[] args = new Object[0];

        public TestNameBuilder(Method method) {
            this.method = method;
        }

        public TestNameBuilder withArguments(Object[] args) {
            this.args = Arrays.copyOf(args, args.length);
            return this;
        }

        public String asString() {
            StringBuilder testName = new StringBuilder(this.method.getName());
            return testName.append(this.argumentsTo(testName)).toString();
        }

        private String argumentsTo(StringBuilder testName) {
            if (this.args.length == 0) {
                return "";
            }
            return ": " + Lambda.join((Object)Lambda.convert((Object)this.args, this.toReadableForm()));
        }

        private Converter<Object, String> toReadableForm() {
            return new Converter<Object, String>(){

                public String convert(Object argument) {
                    return StepArgumentWriter.readableFormOf(argument);
                }
            };
        }
    }
}

