/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.OutcomeSummary;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.TestOutcomesCompromised;
import net.thucydides.core.reports.TestOutcomesError;
import net.thucydides.core.reports.TestOutcomesFailures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultChecker {
    private final File outputDirectory;
    private static final Logger logger = LoggerFactory.getLogger(ResultChecker.class);

    public ResultChecker(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void checkTestResults() {
        Optional<TestOutcomes> outcomes = this.loadOutcomes();
        if (outcomes.isPresent()) {
            this.logOutcomesFrom((TestOutcomes)outcomes.get());
            this.checkTestResultsIn((TestOutcomes)outcomes.get());
        }
    }

    private void logOutcomesFrom(TestOutcomes testOutcomes) {
        logger.info("----------------------");
        logger.info("SERENITY TEST OUTCOMES");
        logger.info("----------------------");
        logger.info("  - Tests executed: " + testOutcomes.getTotal());
        logger.info("  - Tests passed: " + testOutcomes.getPassingTests().getTotal());
        logger.info("  - Tests failed: " + testOutcomes.getFailingTests().getTotal());
        logger.info("  - Tests with errors: " + testOutcomes.getErrorTests().getTotal());
        logger.info("  - Tests pending: " + testOutcomes.getPendingTests().getTotal());
        logger.info("  - Tests compromised: " + testOutcomes.getCompromisedTests().getTotal());
    }

    private void checkTestResultsIn(TestOutcomes testOutcomes) {
        switch (testOutcomes.getResult()) {
            case ERROR: {
                throw new TestOutcomesError(this.testOutcomeSummary(testOutcomes));
            }
            case FAILURE: {
                throw new TestOutcomesFailures(this.testOutcomeSummary(testOutcomes));
            }
            case COMPROMISED: {
                throw new TestOutcomesCompromised(this.testOutcomeSummary(testOutcomes));
            }
        }
    }

    private String testOutcomeSummary(TestOutcomes testOutcomes) {
        int errors = testOutcomes.count(TestType.ANY).withResult(TestResult.ERROR);
        int failures = testOutcomes.count(TestType.ANY).withResult(TestResult.FAILURE);
        int compromised = testOutcomes.count(TestType.ANY).withResult(TestResult.COMPROMISED);
        return Joiner.on((String)" ").join((Object)"THUCYDIDES TEST FAILURES:", (Object)OutcomeSummary.forOutcome(TestResult.ERROR).withCount(errors), new Object[]{OutcomeSummary.forOutcome(TestResult.FAILURE).withCount(failures), OutcomeSummary.forOutcome(TestResult.COMPROMISED).withCount(compromised)});
    }

    private Optional<TestOutcomes> loadOutcomes() {
        TestOutcomes outcomes = null;
        try {
            outcomes = TestOutcomeLoader.loadTestOutcomes().inFormat(OutcomeFormat.JSON).from(this.outputDirectory);
            if (outcomes.getTotal() == 0) {
                outcomes = TestOutcomeLoader.loadTestOutcomes().inFormat(OutcomeFormat.XML).from(this.outputDirectory);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.of(outcomes);
    }
}

