/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.inject.Inject;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdriverCloseBrowser
implements CloseBrowser {
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFacade.class);

    @Inject
    public WebdriverCloseBrowser(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public void closeIfConfiguredForANew(RestartBrowserForEach event) {
        if (this.restartBrowserForANew(event)) {
            ThucydidesWebDriverSupport.closeCurrentDrivers();
        }
    }

    private boolean restartBrowserForANew(RestartBrowserForEach event) {
        return RestartBrowserForEach.configuredIn(this.environmentVariables).restartBrowserForANew(event);
    }

    @Override
    public void closeWhenTheTestsAreFinished(final WebDriver driver) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (driver != null) {
                    try {
                        driver.quit();
                    }
                    catch (WebDriverException mostLikelyLostContactWithTheBrowser) {
                        LOGGER.debug("Failed to close a broswer: {}", (Object)mostLikelyLostContactWithTheBrowser.getMessage());
                    }
                }
            }
        });
    }
}

