/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;

public class VersionProvider {
    private final EnvironmentVariables environmentVariables;

    public VersionProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public VersionProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersion() {
        String path = "/serenity-version.properties";
        Properties props = new Properties();
        try (InputStream stream = this.getClass().getResourceAsStream(path);){
            if (stream == null) {
                String string2 = "UNKNOWN";
                return string2;
            }
            props.load(stream);
            stream.close();
            String string = (String)props.get("application.version");
            return string;
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    public String getBuildNumberText() {
        return this.environmentVariables.getValue(this.buildNumberVariable(), "UNKNOWN");
    }

    private String buildNumberVariable() {
        return this.environmentVariables.getProperty("build.number.variable", "BUILD_NUMBER");
    }
}

