/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.reports.NumberOfThreads;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.core.reports.html.ReportingTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);

    Reporter() {
    }

    public static void generateReportsFor(Collection<ReportingTask> reportingTasks) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        try {
            ArrayList<ReportExecutor> partitions = new ArrayList<ReportExecutor>();
            for (ReportingTask reportingTask : reportingTasks) {
                partitions.add(new ReportExecutor(reportingTask));
            }
            ExecutorService executorPool = Executors.newFixedThreadPool(NumberOfThreads.forIOOperations());
            for (Future executedTask : executorPool.invokeAll(partitions)) {
                executedTask.get();
            }
        }
        catch (Exception e) {
            LOGGER.error("Report generation failed", (Throwable)e);
        }
        LOGGER.debug("Test outcome reports generated in {} ms", (Object)stopwatch.stop());
    }

    private static class ReportExecutor
    implements Callable<Void> {
        private final ReportingTask reportingTask;

        ReportExecutor(ReportingTask reportingTask) {
            this.reportingTask = reportingTask;
        }

        @Override
        public Void call() throws Exception {
            Stopwatch reportingStopwatch = Stopwatch.started();
            this.reportingTask.generateReports();
            LOGGER.debug("{} generated in {} ms", (Object)this.reportingTask.toString(), (Object)reportingStopwatch.stop());
            return null;
        }
    }
}

