/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.serenitybdd.core.SerenitySystemProperties;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.reports.CopyFiles;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.NumberOfThreads;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.html.AggregateReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.Reporter;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.RequirementsReports;
import net.thucydides.core.reports.html.ResultReports;
import net.thucydides.core.reports.html.TagReportingTask;
import net.thucydides.core.reports.html.TagTypeReportingTask;
import net.thucydides.core.requirements.DefaultRequirements;
import net.thucydides.core.requirements.Requirements;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAggregateStoryReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    private String projectName;
    private String relativeLink;
    private final IssueTracking issueTracking;
    private final RequirementsConfiguration requirementsConfiguration;
    private final ReportNameProvider reportNameProvider;
    private final Requirements requirements;
    private final EnvironmentVariables environmentVariables;
    private FormatConfiguration formatConfiguration;
    private Stopwatch stopwatch = new Stopwatch();
    public static final CopyOption[] COPY_OPTIONS = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};

    public HtmlAggregateStoryReporter(String projectName) {
        this(projectName, "");
    }

    public HtmlAggregateStoryReporter(String projectName, Requirements requirements) {
        this(projectName, "", (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), requirements);
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink) {
        this(projectName, relativeLink, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public HtmlAggregateStoryReporter(String projectName, IssueTracking issueTracking) {
        this(projectName, "", issueTracking, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), new DefaultRequirements());
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, EnvironmentVariables environmentVariables) {
        this(projectName, relativeLink, issueTracking, environmentVariables, new DefaultRequirements());
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, EnvironmentVariables environmentVariables, Requirements requirements) {
        this.projectName = projectName;
        this.relativeLink = relativeLink;
        this.issueTracking = issueTracking;
        this.requirementsConfiguration = new RequirementsConfiguration(this.getEnvironmentVariables());
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = new FormatConfiguration(environmentVariables);
        this.reportNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, requirements.getRequirementsService());
        this.requirements = requirements;
    }

    public OutcomeFormat getFormat() {
        return this.formatConfiguration.getPreferredFormat();
    }

    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public TestOutcomes generateReportsForTestResultsFrom(File sourceDirectory) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        this.copyScreenshotsFrom(sourceDirectory);
        LOGGER.debug("Copied screenshots after {} ms", (Object)stopwatch.lapTime());
        TestOutcomes allTestOutcomes = this.loadTestOutcomesFrom(sourceDirectory);
        LOGGER.debug("Loaded test outcomes after {} ms", (Object)stopwatch.lapTime());
        this.generateReportsForTestResultsIn(allTestOutcomes);
        LOGGER.debug("Generated reports after {} ms", (Object)stopwatch.lapTime());
        return allTestOutcomes;
    }

    private void copyScreenshotsFrom(File sourceDirectory) {
        CopyFiles.from(sourceDirectory).to(this.getOutputDirectory());
    }

    public void generateReportsForTestResultsIn(TestOutcomes testOutcomes) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        LOGGER.info("Generating test results for {} tests", (Object)testOutcomes.getTestCount());
        FreemarkerContext context = new FreemarkerContext(this.environmentVariables, this.requirements.getRequirementsService(), this.issueTracking, this.relativeLink);
        RequirementsOutcomes requirementsOutcomes = this.requirements.getRequirementsOutcomeFactory().buildRequirementsOutcomesFrom(testOutcomes);
        LOGGER.info("{} requirements loaded after {} ms", (Object)requirementsOutcomes.getFlattenedRequirementCount(), (Object)stopwatch.lapTime());
        requirementsOutcomes = requirementsOutcomes.withoutUnrelatedRequirements();
        LOGGER.info("{} related requirements found after {} ms", (Object)requirementsOutcomes.getFlattenedRequirementCount(), (Object)stopwatch.lapTime());
        List<String> knownRequirementReportNames = this.requirementReportNamesFrom(requirementsOutcomes, this.reportNameProvider);
        HashSet<ReportingTask> reportingTasks = new HashSet<ReportingTask>();
        reportingTasks.add(new CopyResourcesTask());
        reportingTasks.add(new CopyTestResultsTask());
        reportingTasks.add(new AggregateReportingTask(context, this.environmentVariables, this.requirements.getRequirementsService(), this.getOutputDirectory(), testOutcomes));
        reportingTasks.add(new TagTypeReportingTask(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider, testOutcomes));
        reportingTasks.addAll(TagReportingTask.tagReportsFor(testOutcomes).using(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider, testOutcomes.getTags(), knownRequirementReportNames));
        reportingTasks.addAll(ResultReports.resultReportsFor(testOutcomes, context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider));
        reportingTasks.addAll(RequirementsReports.requirementsReportsFor(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider, this.requirements.getRequirementsOutcomeFactory(), this.requirements.getRequirementsService(), this.relativeLink, testOutcomes, requirementsOutcomes));
        LOGGER.info("Starting generating reports: {} ms", (Object)stopwatch.lapTime());
        this.generateReportsFor(reportingTasks);
        LOGGER.info("Finished generating test results for {} tests after {} ms", (Object)testOutcomes.getTestCount(), (Object)stopwatch.stop());
    }

    private List<String> requirementReportNamesFrom(RequirementsOutcomes requirementsOutcomes, ReportNameProvider reportNameProvider) {
        return Lambda.convert(requirementsOutcomes.getFlattenedRequirementOutcomes(), this.toRequirementReportNames(reportNameProvider));
    }

    private Converter<RequirementOutcome, String> toRequirementReportNames(final ReportNameProvider reportNameProvider) {
        return new Converter<RequirementOutcome, String>(){

            public String convert(RequirementOutcome from) {
                return reportNameProvider.forRequirement(from.getRequirement());
            }
        };
    }

    private void generateReportsFor(Collection<ReportingTask> reportingTasks) throws IOException {
        this.stopwatch.start();
        try {
            Reporter.generateReportsFor(reportingTasks);
            List partitions = Lists.newArrayList();
            for (ReportingTask reportingTask : reportingTasks) {
                partitions.add(new ReportExecutor(reportingTask));
            }
            ExecutorService executorPool = Executors.newFixedThreadPool(NumberOfThreads.forIOOperations());
            for (Future executedTask : executorPool.invokeAll(partitions)) {
                executedTask.get();
            }
        }
        catch (Exception e) {
            LOGGER.error("Report generation failed", (Throwable)e);
        }
        LOGGER.debug("Test outcome reports generated in {} ms", (Object)this.stopwatch.stop());
    }

    private TestOutcomes loadTestOutcomesFrom(File sourceDirectory) throws IOException {
        return TestOutcomeLoader.loadTestOutcomes().inFormat(this.getFormat()).from(sourceDirectory);
    }

    protected SerenitySystemProperties getSystemProperties() {
        return SerenitySystemProperties.getProperties();
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        if (issueTrackerUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.THUCYDIDES_ISSUE_TRACKER_URL, issueTrackerUrl);
        }
    }

    public void setJiraUrl(String jiraUrl) {
        if (jiraUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_URL, jiraUrl);
        }
    }

    public void setJiraProject(String jiraProject) {
        if (jiraProject != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PROJECT, jiraProject);
        }
    }

    public void setJiraUsername(String jiraUsername) {
        if (jiraUsername != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_USERNAME, jiraUsername);
        }
    }

    public void setJiraPassword(String jiraPassword) {
        if (jiraPassword != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PASSWORD, jiraPassword);
        }
    }

    public List<String> getRequirementTypes() {
        List<String> types = this.requirements.getTypes();
        if (types.isEmpty()) {
            LOGGER.warn("No requirement types found in the test outcome requirements: using default requirements");
            return this.requirementsConfiguration.getRequirementTypes();
        }
        return types;
    }

    private class CopyTestResultsTask
    implements ReportingTask {
        private CopyTestResultsTask() {
        }

        @Override
        public void generateReports() throws IOException {
            HtmlAggregateStoryReporter.this.copyTestResultsToOutputDirectory();
        }
    }

    private class CopyResourcesTask
    implements ReportingTask {
        private CopyResourcesTask() {
        }

        @Override
        public void generateReports() throws IOException {
            LOGGER.info("Copying resources to directory");
            HtmlAggregateStoryReporter.this.copyResourcesToOutputDirectory();
        }
    }

    private class ReportExecutor
    implements Callable<Void> {
        private final ReportingTask reportingTask;

        public ReportExecutor(ReportingTask reportingTask) {
            this.reportingTask = reportingTask;
        }

        @Override
        public Void call() throws Exception {
            Stopwatch reportingStopwatch = Stopwatch.started();
            this.reportingTask.generateReports();
            LOGGER.debug("{} generated in {} ms", (Object)this.reportingTask.toString(), (Object)reportingStopwatch.stop());
            return null;
        }
    }
}

