/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;

public class ExampleTable {
    private static final String NEWLINE_CHAR = "\u2424";
    private static final String NEWLINE = "\u0085";
    private static final String LINE_SEPARATOR = "\u2028";
    private static final String PARAGRAPH_SEPARATOR = "\u2089";
    private static final String LEFT_BRACKET = "\u0ff3B";
    private static final String RIGHT_BRACKET = "\u0ff3D";
    List<String> headers;
    List<List<String>> rows = Lists.newArrayList();
    static final Pattern NEW_LINE = Pattern.compile("(\\r\\n)|(\\n)|(\\r)|(\u2424)|(\u2028)|(\u2089)|(\\r\u2424)");
    private static final String SQUARE_BRACKETS_OR_WHITE_SPACE = "[]\u0ff3B\u0ff3D\t";

    public ExampleTable(String tableContents) {
        tableContents = ExampleTable.stripBracketsFromOuterPipes(tableContents);
        List lines = IteratorUtils.toList(Splitter.on((Pattern)NEW_LINE).omitEmptyStrings().trimResults(CharMatcher.anyOf((CharSequence)SQUARE_BRACKETS_OR_WHITE_SPACE)).split((CharSequence)tableContents).iterator());
        this.addHeaderFrom((String)lines.get(0));
        for (int row = 1; row < lines.size(); ++row) {
            this.addRowFrom((String)lines.get(row));
        }
    }

    public static String stripBracketsFromOuterPipes(String text) {
        text = StringUtils.replace((String)text, (String)"[|", (String)"|");
        text = StringUtils.replace((String)text, (String)"\uff3b|", (String)"|");
        text = StringUtils.replace((String)text, (String)"|]", (String)"|");
        text = StringUtils.replace((String)text, (String)"|\uff3d", (String)"|");
        text = StringUtils.replace((String)text, (String)"\u0ff3B|", (String)"|");
        text = StringUtils.replace((String)text, (String)"|\u0ff3D", (String)"|");
        return text;
    }

    private void addRowFrom(String row) {
        this.rows.add(this.cellsFrom(row));
    }

    private void addHeaderFrom(String headerLine) {
        this.headers = this.cellsFrom(headerLine);
    }

    private List<String> cellsFrom(String line) {
        if ((line = line.trim()).startsWith("|")) {
            line = line.substring(1);
        }
        if (line.endsWith("|")) {
            line = line.substring(0, line.length() - 1);
        }
        return IteratorUtils.toList(Splitter.on((String)"|").trimResults().split((CharSequence)line).iterator());
    }

    public String inHtmlFormat() {
        return "<table class='embedded'>" + this.getHtmlHeader() + this.getHtmlBody() + "</table>";
    }

    public String getHtmlHeader() {
        StringBuffer htmlHeader = new StringBuffer();
        htmlHeader.append("<thead>");
        for (String header : this.headers) {
            htmlHeader.append("<th>").append(header).append("</th>");
        }
        htmlHeader.append("</thead>");
        return htmlHeader.toString();
    }

    public String getHtmlBody() {
        StringBuffer htmlBody = new StringBuffer();
        htmlBody.append("<tbody>");
        for (List<String> row : this.rows) {
            htmlBody.append("<tr>");
            for (String cell : row) {
                htmlBody.append("<td>").append(cell).append("</td>");
            }
            htmlBody.append("</tr>");
        }
        htmlBody.append("</tbody>");
        return htmlBody.toString();
    }
}

