/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.model.TestResult;

public class TestResultList {
    public static TestResult overallResultFrom(List<TestResult> results) {
        ImmutableList testResults = ImmutableList.copyOf(results);
        if (testResults.isEmpty()) {
            return TestResult.SUCCESS;
        }
        if (testResults.contains((Object)TestResult.COMPROMISED)) {
            return TestResult.COMPROMISED;
        }
        if (testResults.contains((Object)TestResult.ERROR)) {
            return TestResult.ERROR;
        }
        if (testResults.contains((Object)TestResult.FAILURE)) {
            return TestResult.FAILURE;
        }
        if (testResults.contains((Object)TestResult.PENDING)) {
            return TestResult.PENDING;
        }
        if (TestResultList.containsOnly((List<TestResult>)testResults, TestResult.IGNORED)) {
            return TestResult.IGNORED;
        }
        if (TestResultList.containsOnly((List<TestResult>)testResults, TestResult.SKIPPED)) {
            return TestResult.SKIPPED;
        }
        if (TestResultList.containsOnly((List<TestResult>)testResults, TestResult.SUCCESS, TestResult.IGNORED, TestResult.SKIPPED)) {
            return TestResult.SUCCESS;
        }
        return TestResult.SUCCESS;
    }

    private static boolean containsOnly(List<TestResult> testResults, TestResult ... values) {
        for (TestResult result : testResults) {
            if (AuthorisedResults.allows(values, result)) continue;
            return false;
        }
        return true;
    }

    private static class AuthorisedResults {
        private AuthorisedResults() {
        }

        public static boolean allows(TestResult[] allowedValues, TestResult result) {
            for (TestResult allowedValue : allowedValues) {
                if (result != allowedValue) continue;
                return true;
            }
            return false;
        }
    }
}

