/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.digest.Digest;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class ReportNamer {
    private ReportType type;
    private boolean compressedFilename = true;

    public static ReportNamer forReportType(ReportType type) {
        return new ReportNamer(type);
    }

    private ReportNamer(ReportType type) {
        this(type, ConfiguredEnvironment.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.SERENITY_COMPRESS_FILENAMES.getPropertyName(), true));
    }

    public ReportNamer(ReportType type, boolean compressedFilename) {
        this.type = type;
        this.compressedFilename = compressedFilename;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome) {
        String testName = this.getBaseTestNameFor(testOutcome);
        String testNameWithoutIndex = NameConverter.stripIndexesFrom(testName);
        return NameConverter.underscore(this.normalizedVersionOf(testNameWithoutIndex));
    }

    private String getBaseTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        } else if (testOutcome.getPath() != null) {
            testName = NameConverter.underscore(testOutcome.getPath());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getQualifiedMethodName());
        return this.pathFrom(testOutcome) + NameConverter.underscore(NameConverter.withNoIssueNumbers(this.appendToIfNotNull(testName, scenarioName)));
    }

    public String getSimpleTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getName());
        testName = this.pathFrom(testOutcome) + NameConverter.withNoIssueNumbers(NameConverter.withNoArguments(this.appendToIfNotNull(testName, scenarioName)));
        return this.appendSuffixTo(Digest.ofTextValue(testName));
    }

    private String pathFrom(TestOutcome testOutcome) {
        return testOutcome.getPath() != null ? testOutcome.getPath() + "/" : "";
    }

    private String appendToIfNotNull(String baseString, String nextElement) {
        if (StringUtils.isNotEmpty((CharSequence)baseString)) {
            return baseString + "_" + nextElement;
        }
        return nextElement;
    }

    public String getNormalizedTestNameFor(Story userStory) {
        return this.getNormalizedTestNameFor(userStory.getName());
    }

    public String getNormalizedTestNameFor(String name) {
        return this.normalizedVersionOf(NameConverter.underscore(name.toLowerCase()));
    }

    private String normalizedVersionOf(String text) {
        return this.compressedFilename ? this.appendSuffixTo(Digest.ofTextValue(text)) : this.appendSuffixTo(text);
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }

    public ReportNamer withNoCompression() {
        return new ReportNamer(this.type, false);
    }
}

