/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import org.openqa.selenium.support.ui.Select;

class DropdownSelector {
    private final WebElementFacadeImpl webElementFacade;

    public DropdownSelector(WebElementFacadeImpl webElementFacade) {
        this.webElementFacade = webElementFacade;
    }

    public WebElementFacade byVisibleText(String label) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        this.webElementFacade.waitUntilElementAvailable();
        Select select = new Select(this.webElementFacade.getElement());
        select.selectByVisibleText(label);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public String visibleTextValue() {
        if (this.webElementFacade.driverIsDisabled()) {
            return "";
        }
        this.webElementFacade.waitUntilVisible();
        Select select = new Select(this.webElementFacade.getElement());
        return select.getFirstSelectedOption().getText();
    }

    public WebElementFacade byValue(String value) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        this.webElementFacade.waitUntilElementAvailable();
        Select select = new Select(this.webElementFacade.getElement());
        select.selectByValue(value);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public String value() {
        if (this.webElementFacade.driverIsDisabled()) {
            return "";
        }
        this.webElementFacade.waitUntilVisible();
        Select select = new Select(this.webElementFacade.getElement());
        return select.getFirstSelectedOption().getAttribute("value");
    }

    public WebElementFacade byIndex(int indexValue) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        this.webElementFacade.waitUntilElementAvailable();
        Select select = new Select(this.webElementFacade.getElement());
        select.selectByIndex(indexValue);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }
}

