/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Joiner;
import com.opera.core.systems.OperaDriver;
import io.appium.java_client.AppiumDriver;
import net.thucydides.core.webdriver.ProvidedDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;

public enum SupportedWebDriver {
    FIREFOX(FirefoxDriver.class),
    CHROME(ChromeDriver.class),
    OPERA(OperaDriver.class),
    HTMLUNIT(HtmlUnitDriver.class),
    PHANTOMJS(PhantomJSDriver.class),
    REMOTE(RemoteWebDriver.class),
    IEXPLORER(InternetExplorerDriver.class),
    SAFARI(SafariDriver.class),
    APPIUM(AppiumDriver.class),
    PROVIDED(ProvidedDriver.class);

    private final Class<? extends WebDriver> webdriverClass;

    private SupportedWebDriver(Class<? extends WebDriver> webdriverClass) {
        this.webdriverClass = webdriverClass;
    }

    public Class<? extends WebDriver> getWebdriverClass() {
        return this.webdriverClass;
    }

    public static String listOfSupportedDrivers() {
        return Joiner.on((String)", ").join((Object[])SupportedWebDriver.values());
    }

    public static SupportedWebDriver getClosestDriverValueTo(String value) {
        SupportedWebDriver closestDriver = null;
        int closestDriverDistance = Integer.MAX_VALUE;
        for (SupportedWebDriver supportedDriver : SupportedWebDriver.values()) {
            int distance = StringUtils.getLevenshteinDistance((CharSequence)supportedDriver.toString(), (CharSequence)value);
            if (distance >= closestDriverDistance) continue;
            closestDriverDistance = distance;
            closestDriver = supportedDriver;
        }
        return closestDriver;
    }

    public static SupportedWebDriver getDriverTypeFor(String value) throws UnsupportedDriverException {
        try {
            return SupportedWebDriver.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SupportedWebDriver closestMatchingDriver = SupportedWebDriver.getClosestDriverValueTo(value);
            throw new UnsupportedDriverException("Unsupported browser type: " + value + ". Did you mean " + closestMatchingDriver.toString().toLowerCase() + "?", e);
        }
    }

    public static SupportedWebDriver forClass(Class<?> driverClass) {
        for (SupportedWebDriver supportedWebDriver : SupportedWebDriver.values()) {
            if (!driverClass.equals(supportedWebDriver.getWebdriverClass())) continue;
            return supportedWebDriver;
        }
        throw new IllegalArgumentException("Driver not supported: " + driverClass);
    }
}

