/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.junit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.junit.JUnitXMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitXMLOutcomeReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitXMLOutcomeReporter.class);
    private final File outputDirectory;
    private final JUnitXMLConverter junitXMLConverter;

    public JUnitXMLOutcomeReporter(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.junitXMLConverter = new JUnitXMLConverter();
    }

    public void generateReportsFor(TestOutcomes testOutcomes) throws IOException {
        LOGGER.info("GENERATING JUNIT REPORTS");
        Preconditions.checkNotNull((Object)this.outputDirectory);
        Map<String, List<TestOutcome>> testOutcomesGroupedByTestCase = this.groupByTestCase(testOutcomes);
        for (String testCase : testOutcomesGroupedByTestCase.keySet()) {
            List<TestOutcome> testCaseOutcomes = testOutcomesGroupedByTestCase.get(testCase);
            String reportFilename = this.reportFilenameFor(testCaseOutcomes.get(0));
            File report = new File(this.getOutputDirectory(), reportFilename);
            LOGGER.info("GENERATING JUNIT REPORT " + reportFilename);
            try {
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(report));
                Throwable throwable = null;
                try {
                    this.junitXMLConverter.write(testCase, testCaseOutcomes, outputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)outputStream).close();
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
    }

    private String reportFilenameFor(TestOutcome testOutcome) {
        ReportNamer reportNamer = ReportNamer.forReportType(ReportType.XML);
        return "SERENITY-JUNIT-" + reportNamer.getNormalizedTestNameFor(testOutcome);
    }

    private String filenameCompatible(String testCase) {
        return testCase.replaceAll(" ", "_");
    }

    private Map<String, List<TestOutcome>> groupByTestCase(TestOutcomes testOutcomes) {
        HashMap groupedTestOutcomes = Maps.newHashMap();
        for (TestOutcome testOutcome : testOutcomes.getOutcomes()) {
            String testCaseName;
            String string = testCaseName = testOutcome.getTestCaseName() != null ? testOutcome.getTestCaseName() : testOutcome.getStoryTitle();
            if (groupedTestOutcomes.containsKey(testCaseName)) {
                ((List)groupedTestOutcomes.get(testCaseName)).add(testOutcome);
                continue;
            }
            ArrayList outcomes = Lists.newArrayList();
            outcomes.add(testOutcome);
            groupedTestOutcomes.put(testCaseName, outcomes);
        }
        return groupedTestOutcomes;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    private String reportFor(TestOutcome testOutcome) {
        return "SERENITY-TEST-" + testOutcome.getReportName(ReportType.JUNIT);
    }
}

