/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html.screenshots;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.model.Screenshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotFormatter {
    private final Screenshot screenshot;
    private final File sourceDirectory;
    private final boolean shouldKeepOriginalScreenshots;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenshotFormatter.class);

    private ScreenshotFormatter(Screenshot screenshot, File sourceDirectory, boolean shouldKeepOriginalScreenshots) {
        this.screenshot = screenshot;
        this.sourceDirectory = sourceDirectory;
        this.shouldKeepOriginalScreenshots = shouldKeepOriginalScreenshots;
    }

    public static ScreenshotFormatter forScreenshot(Screenshot screenshot) {
        return new ScreenshotFormatter(screenshot, null, false);
    }

    public ScreenshotFormatter inDirectory(File sourceDirectory) {
        return new ScreenshotFormatter(this.screenshot, sourceDirectory, this.shouldKeepOriginalScreenshots);
    }

    public ScreenshotFormatter keepOriginals(boolean shouldKeepOriginalScreenshots) {
        return new ScreenshotFormatter(this.screenshot, this.sourceDirectory, shouldKeepOriginalScreenshots);
    }

    public Screenshot expandToHeight(int targetHeight) throws IOException {
        File screenshotFile = new File(this.sourceDirectory, this.screenshot.getFilename());
        File resizedFile = this.resizedTargetFile(this.screenshot.getFilename());
        LOGGER.info("Resizing image " + screenshotFile + " to " + resizedFile);
        LOGGER.info("Screenshot exists" + screenshotFile.exists());
        LOGGER.info("Resized screenshot exists" + resizedFile.exists());
        if (!resizedFile.exists()) {
            resizedFile = this.resizedImage(screenshotFile, targetHeight);
            return new Screenshot(resizedFile.getName(), this.screenshot.getDescription(), this.screenshot.getWidth(), this.screenshot.getError());
        }
        return this.screenshot;
    }

    private File resizedTargetFile(String screenshotFilename) {
        return new File(this.sourceDirectory, "scaled_" + screenshotFilename);
    }

    private File resizedImage(File screenshotFile, int maxHeight) throws IOException {
        LOGGER.info("Resizing image " + screenshotFile);
        File scaledFile = this.resizedTargetFile(screenshotFile.getName());
        if (!scaledFile.exists()) {
            ResizableImage scaledImage = ResizableImage.loadFrom(screenshotFile).rescaleCanvas(maxHeight);
            scaledImage.saveTo(scaledFile);
            LOGGER.info("Scaled image saved to " + scaledFile);
        }
        LOGGER.info("Resizing image done -> " + scaledFile.getAbsolutePath());
        return scaledFile;
    }

    private void saveCopyOf(File screenshotFile) throws IOException {
        String backupScreenshotFilename = "original_" + screenshotFile.getName();
        Files.copy(screenshotFile.toPath(), new File(this.sourceDirectory, backupScreenshotFilename).toPath(), new CopyOption[0]);
    }
}

