/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reports.ExecutorServiceProvider;
import net.thucydides.core.util.EnvironmentVariables;

public class MultithreadExecutorServiceProvider
implements ExecutorServiceProvider {
    int corePoolSize = 4;
    int maximumPoolSize = 8;
    int keepAliveTime = 60000;
    private ExecutorService executorService;

    @Inject
    public MultithreadExecutorServiceProvider(EnvironmentVariables environmentVariables) {
        this.corePoolSize = ThucydidesSystemProperty.REPORT_THREADS.integerFrom(environmentVariables, 4);
        this.maximumPoolSize = ThucydidesSystemProperty.REPORT_MAX_THREADS.integerFrom(environmentVariables, 8);
        this.keepAliveTime = ThucydidesSystemProperty.REPORT_KEEP_ALIVE_TIME.integerFrom(environmentVariables, 60000);
    }

    @Override
    public ExecutorService getExecutorService() {
        if (this.executorService == null) {
            int corePoolSize = 4;
            int maximumPoolSize = 8;
            int keepAliveTime = 60000;
            this.executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return this.executorService;
    }
}

