/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.rest;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.rest.RestMethod;

public class RestQuery {
    private final RestMethod method;
    private final String path;
    private final String content;
    private final String contentType;
    private final Optional<? extends List<Object>> parameters;
    private final Optional<? extends Map<String, ?>> parameterMap;
    private final String responseBody;
    private final Integer statusCode;

    private RestQuery(RestMethod method, String path, List<Object> parameters, Map<String, ?> parameterMap, String content, String contentType, String responseBody, Integer statusCode) {
        this.method = method;
        this.path = path;
        this.parameters = Optional.fromNullable(parameters);
        this.parameterMap = Optional.fromNullable(parameterMap);
        this.content = content;
        this.contentType = contentType;
        this.responseBody = responseBody;
        this.statusCode = statusCode;
    }

    public RestQuery(RestMethod method, String path) {
        this(method, path, null, null, null, null, null, null);
    }

    public RestQuery withParameters(List<Object> parameters) {
        return new RestQuery(this.method, this.path, parameters, null, this.content, this.contentType, this.responseBody, this.statusCode);
    }

    public RestQuery withParameters(Map<String, ?> parameterMap) {
        return new RestQuery(this.method, this.path, null, parameterMap, this.content, this.contentType, this.responseBody, this.statusCode);
    }

    public RestQuery withResponse(String responseBody) {
        return new RestQuery(this.method, this.path, (List)this.parameters.orNull(), (Map)this.parameterMap.orNull(), this.content, this.contentType, responseBody, this.statusCode);
    }

    public RestQuery withStatusCode(Integer statusCode) {
        return new RestQuery(this.method, this.path, (List)this.parameters.orNull(), (Map)this.parameterMap.orNull(), this.content, this.contentType, this.responseBody, statusCode);
    }

    public RestQuery withContent(String content) {
        return new RestQuery(this.method, this.path, (List)this.parameters.orNull(), (Map)this.parameterMap.orNull(), content, this.contentType, this.responseBody, this.statusCode);
    }

    public RestQuery withContentType(String contentType) {
        return new RestQuery(this.method, this.path, (List)this.parameters.orNull(), (Map)this.parameterMap.orNull(), this.content, contentType, this.responseBody, this.statusCode);
    }

    public RestMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Optional<? extends List<Object>> getParameters() {
        return this.parameters;
    }

    public Optional<? extends Map<String, ?>> getParameterMap() {
        return this.parameterMap;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public boolean hasParameters() {
        return this.parameters.isPresent() || this.parameterMap.isPresent();
    }

    public String toString() {
        return this.getFormattedQuery();
    }

    public String getFormattedQuery() {
        return (Object)((Object)this.getMethod()) + " " + this.injectParametersInto(this.getPath());
    }

    private String injectParametersInto(String path) {
        if (this.parameters.isPresent()) {
            return this.injectParameterValuesInto(path, (List)this.parameters.get());
        }
        if (this.parameterMap.isPresent()) {
            return this.injectParameterMapInto(path, (Map)this.parameterMap.get());
        }
        return path;
    }

    private String injectParameterMapInto(String path, Map<String, ?> parameterMap) {
        for (String parameterName : parameterMap.keySet()) {
            String parameterValue = parameterMap.get(parameterName).toString();
            path = path.replaceAll("\\{" + parameterName + "\\}", parameterValue);
        }
        return path;
    }

    private String injectParameterValuesInto(String path, List<Object> parameters) {
        for (Object parameterValue : parameters) {
            int variableStart = path.indexOf("{");
            int variableEnd = path.indexOf("}");
            if (variableStart < 0 || variableEnd <= variableStart) continue;
            path = path.substring(0, variableStart) + parameterValue + path.substring(variableEnd + 1);
        }
        return path;
    }

    public static RestQueryBuilder withMethod(RestMethod method) {
        return new RestQueryBuilder(method);
    }

    public static class RestQueryBuilder {
        private RestMethod method;

        public RestQueryBuilder(RestMethod method) {
            this.method = method;
        }

        public RestQuery andPath(String path) {
            return new RestQuery(this.method, path);
        }
    }
}

