/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.ThucydidesReporter;
import net.thucydides.core.reports.html.HtmlResourceCopier;
import net.thucydides.core.reports.templates.ReportTemplate;
import net.thucydides.core.reports.templates.TemplateManager;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;

public abstract class HtmlReporter
extends ThucydidesReporter {
    private static final String DEFAULT_RESOURCE_DIRECTORY = "report-resources";
    private static final String DEFAULT_SOURCE_DIR = "target/site/thucydides";
    private String resourceDirectory = "report-resources";
    private final TemplateManager templateManager = (TemplateManager)Injectors.getInjector().getInstance(TemplateManager.class);
    private final EnvironmentVariables environmentVariables;
    protected static final String TIMESTAMP_FORMAT = "dd-MM-YYYY HH:mm";
    private boolean alreadyCopied = false;

    public HtmlReporter() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public HtmlReporter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    protected void copyResourcesToOutputDirectory() throws IOException {
        if (!this.alreadyCopied) {
            this.alreadyCopied = true;
            this.updateResourceDirectoryFromSystemPropertyIfDefined();
            this.copyResources();
        }
    }

    private void copyResources() throws IOException {
        HtmlResourceCopier copier = new HtmlResourceCopier(this.getResourceDirectory());
        copier.copyHTMLResourcesTo(this.getOutputDirectory());
    }

    protected void copyTestResultsToOutputDirectory() throws IOException {
        File testResultsSource = this.getSourceDirectoryOrDefault();
        if (!this.getOutputDirectory().getAbsolutePath().equals(testResultsSource.getAbsolutePath()) && testResultsSource.exists()) {
            FileUtils.copyDirectory((File)testResultsSource, (File)this.getOutputDirectory(), (FileFilter)this.withXMLorHTMLorCSVFiles());
        }
    }

    private FileFilter withXMLorHTMLorCSVFiles() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".xml") || file.getName().endsWith(".html") || file.getName().endsWith(".csv");
            }
        };
    }

    private File getSourceDirectoryOrDefault() {
        String source = this.getSourceDirectory() != null ? this.getSourceDirectory().getAbsolutePath() : DEFAULT_SOURCE_DIR;
        return new File(source);
    }

    private void updateResourceDirectoryFromSystemPropertyIfDefined() {
        String systemDefinedResourceDirectory = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.THUCYDIDES_REPORT_RESOURCES.getPropertyName());
        if (systemDefinedResourceDirectory != null) {
            this.setResourceDirectory(systemDefinedResourceDirectory);
        }
    }

    protected File writeReportToOutputDirectory(String reportFilename, String htmlContents) throws IOException {
        File report = new File(this.getOutputDirectory(), reportFilename);
        this.writeToFile(htmlContents, report);
        return report;
    }

    private void writeToFile(String htmlContents, File report) throws IOException {
        String[] lines = htmlContents.split("\\r?\\n");
        try (BufferedWriter writer = Files.newBufferedWriter(report.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    protected String timestampFrom(TestOutcomes rootOutcomes) {
        return this.timestampFrom(this.currentTime());
    }

    protected String timestampFrom(DateTime startTime) {
        return startTime == null ? "" : startTime.toString(TIMESTAMP_FORMAT);
    }

    protected void addTimestamp(TestOutcome testOutcome, Map<String, Object> context) {
        context.put("timestamp", this.timestampFrom(this.currentTime()));
    }

    protected DateTime currentTime() {
        return new DateTime();
    }

    protected Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }

    protected class Merger {
        final String templateFile;

        public Merger(String templateFile) {
            this.templateFile = templateFile;
        }

        public String usingContext(Map<String, Object> context) {
            try {
                ReportTemplate template = HtmlReporter.this.getTemplateManager().getTemplateFrom(this.templateFile);
                StringWriter sw = new StringWriter();
                template.merge(context, sw);
                return sw.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to merge template: " + e.getMessage(), e);
            }
        }
    }
}

