/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import ch.lambdaj.Lambda;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Key;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.html.ExampleTable;
import net.thucydides.core.reports.renderer.Asciidoc;
import net.thucydides.core.reports.renderer.MarkupRenderer;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public class Formatter {
    private static final String ISSUE_NUMBER_REGEXP = "#([A-Z][A-Z0-9-_]*)?-?\\d+";
    private static final Pattern shortIssueNumberPattern = Pattern.compile("#([A-Z][A-Z0-9-_]*)?-?\\d+");
    private static final String FULL_ISSUE_NUMBER_REGEXP = "([A-Z][A-Z0-9-_]*)-\\d+";
    private static final Pattern fullIssueNumberPattern = Pattern.compile("([A-Z][A-Z0-9-_]*)-\\d+");
    private static final String ISSUE_LINK_FORMAT = "<a target=\"_blank\" href=\"{0}\">{1}</a>";
    private static final String ELIPSE = "&hellip;";
    private static final String ASCIIDOC = "asciidoc";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;
    private final MarkupRenderer asciidocRenderer;
    private final CharSequenceTranslator ESCAPE_SPECIAL_CHARS = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.HTML40_EXTENDED_ESCAPE())});

    @Inject
    public Formatter(IssueTracking issueTracking, EnvironmentVariables environmentVariables) {
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
        this.asciidocRenderer = (MarkupRenderer)Injectors.getInjector().getInstance(Key.get(MarkupRenderer.class, Asciidoc.class));
    }

    public Formatter(IssueTracking issueTracking) {
        this(issueTracking, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public String renderAsciidoc(String text) {
        return this.stripNewLines(this.asciidocRenderer.render(text));
    }

    private String stripNewLines(String render) {
        return render.replaceAll("\n", "");
    }

    public String stripQualifications(String title) {
        if (title.contains("[")) {
            return title.substring(0, title.lastIndexOf("["));
        }
        return title;
    }

    public static List<String> issuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        List<String> issuesWithHash = extractor.getShortenedIssues();
        List<String> allIssues = extractor.getFullIssues();
        allIssues.addAll(issuesWithHash);
        return allIssues;
    }

    public String addLinks(String value) {
        if (this.issueTracking == null) {
            return value;
        }
        String formattedValue = value;
        if (this.issueTracking.getIssueTrackerUrl() != null) {
            formattedValue = this.insertFullIssueTrackingUrls(value);
        }
        if (this.issueTracking.getShortenedIssueTrackerUrl() != null) {
            formattedValue = this.insertShortenedIssueTrackingUrls(formattedValue);
        }
        return formattedValue;
    }

    public String renderDescription(String text) {
        String format = this.environmentVariables.getProperty(ThucydidesSystemProperty.NARRATIVE_FORMAT, "");
        if (this.isRenderedHtml(text)) {
            return text;
        }
        if (format.equalsIgnoreCase(ASCIIDOC)) {
            return this.renderAsciidoc(text);
        }
        return this.addLineBreaks(text);
    }

    private boolean isRenderedHtml(String text) {
        return text != null && text.startsWith("<");
    }

    public String addLineBreaks(String text) {
        return text != null ? text.replaceAll("\r\n", "<br>").replaceAll("\n", "<br>") : "";
    }

    public String convertAnyTables(String text) {
        text = this.convertNonStandardNLChars(text);
        if (this.shouldFormatEmbeddedTables() && this.containsEmbeddedTable(text)) {
            text = this.withTablesReplaced(text);
        }
        return text;
    }

    private String withTablesReplaced(String text) {
        List<String> unformattedTables = this.getEmbeddedTablesIn(text);
        for (String unformattedTable : unformattedTables) {
            ExampleTable table = new ExampleTable(unformattedTable);
            text = text.replace(unformattedTable, table.inHtmlFormat());
        }
        text = text.replaceAll(this.newLineUsedIn(text), "<br>");
        return text;
    }

    private String convertNonStandardNLChars(String text) {
        text = StringUtils.replace((String)text, (String)"\r\u2424", (String)NEW_LINE);
        return StringUtils.replace((String)text, (String)"\u2424", (String)NEW_LINE);
    }

    private boolean shouldFormatEmbeddedTables() {
        return this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.IGNORE_EMBEDDED_TABLES, false) == false;
    }

    private boolean containsEmbeddedTable(String text) {
        return this.positionOfFirstPipeIn(text) >= 0 && this.positionOfLastPipeIn(text) >= 0;
    }

    private int positionOfLastPipeIn(String text) {
        return text.indexOf("|", this.positionOfFirstPipeIn(text) + 1);
    }

    private int positionOfFirstPipeIn(String text) {
        return text.indexOf("|");
    }

    private List<String> getEmbeddedTablesIn(String text) {
        ArrayList embeddedTables = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        StringBuffer tableText = new StringBuffer();
        boolean inTable = false;
        String newLine = this.newLineUsedIn(text);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!inTable && line.contains("|")) {
                    inTable = true;
                } else if (inTable && !line.contains("|") && !this.isBlank(line)) {
                    embeddedTables.add(tableText.toString().trim());
                    tableText = new StringBuffer();
                    inTable = false;
                }
                if (!inTable) continue;
                tableText.append(line).append(newLine);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not process embedded table", e);
        }
        if (!tableText.toString().isEmpty()) {
            embeddedTables.add(tableText.toString().trim());
        }
        return embeddedTables;
    }

    private String getFirstEmbeddedTable(String text) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        StringBuffer tableText = new StringBuffer();
        boolean inTable = false;
        String newLine = this.newLineUsedIn(text);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!inTable && line.contains("|")) {
                    inTable = true;
                } else if (inTable && !line.contains("|") && !this.isBlank(line)) break;
                if (!inTable) continue;
                tableText.append(line).append(newLine);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not process embedded table", e);
        }
        return tableText.toString().trim();
    }

    private boolean isBlank(String line) {
        return StringUtils.isBlank((CharSequence)line.trim());
    }

    private String newLineUsedIn(String text) {
        if (text.contains("\r\n")) {
            return "\r\n";
        }
        if (text.contains("\n")) {
            return "\n";
        }
        if (text.contains("\r")) {
            return "\r";
        }
        return NEW_LINE;
    }

    public String htmlCompatible(Object fieldValue) {
        return this.addLineBreaks(this.ESCAPE_SPECIAL_CHARS.translate((CharSequence)(fieldValue != null ? this.stringFormOf(fieldValue) : "")));
    }

    private String stringFormOf(Object fieldValue) {
        if (Iterable.class.isAssignableFrom(fieldValue.getClass())) {
            return "[" + Lambda.join((Object)fieldValue) + "]";
        }
        return fieldValue.toString();
    }

    public String truncatedHtmlCompatible(String text, int length) {
        return this.addLineBreaks(this.ESCAPE_SPECIAL_CHARS.translate((CharSequence)this.truncate(text, length)));
    }

    private String truncate(String text, int length) {
        if (text.length() > length) {
            return text.substring(0, length).trim() + ELIPSE;
        }
        return text;
    }

    private String replaceWithTokens(String value, List<String> issues) {
        List<String> sortedIssues = this.inOrderOfDecreasingLength(issues);
        for (int i = 0; i < sortedIssues.size(); ++i) {
            value = value.replaceAll(sortedIssues.get(i), "%%%" + i + "%%%");
        }
        return value;
    }

    private List<String> inOrderOfDecreasingLength(List<String> issues) {
        ArrayList sortedIssues = Lists.newArrayList(issues);
        Collections.sort(sortedIssues, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return sortedIssues;
    }

    public static List<String> shortenedIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getShortenedIssues();
    }

    public static List<String> fullIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getFullIssues();
    }

    private String insertShortenedIssueTrackingUrls(String value) {
        String issueUrlFormat = this.issueTracking.getShortenedIssueTrackerUrl();
        List<String> issues = this.sortByDecreasingSize(Formatter.shortenedIssuesIn(value));
        String formattedValue = this.replaceWithTokens(value, issues);
        int i = 0;
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, this.stripLeadingHashFrom(issue));
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            String token = "%%%" + i++ + "%%%";
            formattedValue = formattedValue.replaceAll(token, issueLink);
        }
        return formattedValue;
    }

    private String insertFullIssueTrackingUrls(String value) {
        String issueUrlFormat = this.issueTracking.getIssueTrackerUrl();
        List<String> issues = this.sortByDecreasingSize(Formatter.fullIssuesIn(value));
        String formattedValue = this.replaceWithTokens(value, issues);
        int i = 0;
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, issue);
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            String token = "%%%" + i++ + "%%%";
            formattedValue = formattedValue.replaceAll(token, issueLink);
        }
        return formattedValue;
    }

    private List<String> sortByDecreasingSize(List<String> issues) {
        ArrayList sortedIssues = Lists.newArrayList(issues);
        Collections.sort(sortedIssues, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return new Integer(-a.length()).compareTo(new Integer(b.length()));
            }
        });
        return sortedIssues;
    }

    public String formatWithFields(String textToFormat, List<String> fields) {
        String textWithEscapedFields = textToFormat;
        for (String field : fields) {
            textWithEscapedFields = textWithEscapedFields.replaceAll("<" + field + ">", "&lt;" + field + "&gt;");
        }
        return this.addLineBreaks(this.removeMacros(this.convertAnyTables(textWithEscapedFields)));
    }

    private String removeMacros(String textToFormat) {
        return textToFormat.replaceAll("\\{trim=false\\}\\s*\\r?\\n", "");
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }

    static class IssueExtractor {
        private String workingCopy;

        IssueExtractor(String initialValue) {
            this.workingCopy = initialValue;
        }

        public List<String> getShortenedIssues() {
            Matcher matcher = shortIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (matcher.find()) {
                String issue = matcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, "");
            }
            return issues;
        }

        public List<String> getFullIssues() {
            Matcher unhashedMatcher = fullIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (unhashedMatcher.find()) {
                String issue = unhashedMatcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, "");
            }
            return issues;
        }
    }
}

