/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.beust.jcommander.internal.Maps;
import com.google.common.base.Optional;
import java.util.Map;
import java.util.Stack;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.Duration;

public class TimeoutStack {
    Map<WebDriver, Stack<Duration>> timeouts = Maps.newHashMap();

    public void pushTimeoutFor(WebDriver driver, Duration implicitTimeout) {
        if (!this.timeouts.containsKey(driver)) {
            this.timeouts.put(driver, new Stack());
        }
        this.timeouts.get(driver).push(implicitTimeout);
    }

    public Optional<Duration> popTimeoutFor(WebDriver driver) {
        if (this.timeouts.containsKey(driver)) {
            return this.timeouts.get(driver).isEmpty() ? Optional.absent() : Optional.of((Object)this.timeouts.get(driver).pop());
        }
        return Optional.absent();
    }

    public Boolean containsTimeoutFor(WebDriver driver) {
        return this.timeouts.containsKey(driver) && !this.timeouts.get(driver).isEmpty();
    }

    public Optional<Duration> currentTimeoutValueFor(WebDriver driver) {
        if (this.containsTimeoutFor(driver).booleanValue()) {
            return Optional.of((Object)this.timeouts.get(driver).peek());
        }
        return Optional.absent();
    }
}

