/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;

public class RootCauseAnalyzer {
    private final Throwable thrownException;

    public RootCauseAnalyzer(Throwable thrownException) {
        this.thrownException = thrownException;
    }

    public FailureCause getRootCause() {
        Throwable originalException = this.thrownException.getCause() != null ? this.thrownException.getCause() : this.thrownException;
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(this.thrownException.getStackTrace());
        return new FailureCause(originalException, stackTraceSanitizer.getSanitizedStackTrace());
    }

    public String getClassname() {
        return this.getRootCause().getErrorType();
    }

    public String getMessage() {
        return this.getRootCause().getMessage();
    }
}

