/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Preconditions;
import io.appium.java_client.AppiumDriver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.pages.PageObject;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureException;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilitySet;
import net.thucydides.core.webdriver.ElementProxyCreator;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.ProvidedDriver;
import net.thucydides.core.webdriver.ProvidedDriverConfiguration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverInstanceFactory;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import net.thucydides.core.webdriver.capabilities.BrowserStackRemoteDriverCapabilities;
import net.thucydides.core.webdriver.capabilities.SauceRemoteDriverCapabilities;
import net.thucydides.core.webdriver.chrome.OptionsSplitter;
import net.thucydides.core.webdriver.firefox.FirefoxProfileEnhancer;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import net.thucydides.core.webdriver.phantomjs.PhantomJSCapabilityEnhancer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    public static final String DEFAULT_DRIVER = "firefox";
    public static final String REMOTE_DRIVER = "remote";
    private final WebdriverInstanceFactory webdriverInstanceFactory;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFactory.class);
    private ProfilesIni allProfiles;
    private static final int DEFAULT_HEIGHT = 700;
    private static final int DEFAULT_WIDTH = 960;
    private final EnvironmentVariables environmentVariables;
    private final FirefoxProfileEnhancer firefoxProfileEnhancer;
    private final FixtureProviderService fixtureProviderService;
    private final ElementProxyCreator proxyCreator;
    private final BrowserStackRemoteDriverCapabilities browserStackRemoteDriverCapabilities;
    private final SauceRemoteDriverCapabilities sauceRemoteDriverCapabilities;
    private final Integer EXTRA_TIME_TO_TAKE_SCREENSHOTS = 180;

    public WebDriverFactory() {
        this(new WebdriverInstanceFactory(), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables) {
        this(new WebdriverInstanceFactory(), environmentVariables);
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables) {
        this(webdriverInstanceFactory, environmentVariables, new FirefoxProfileEnhancer(environmentVariables));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        this(webdriverInstanceFactory, environmentVariables, firefoxProfileEnhancer, (FixtureProviderService)Injectors.getInjector().getInstance(FixtureProviderService.class), (ElementProxyCreator)Injectors.getInjector().getInstance(ElementProxyCreator.class));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer, FixtureProviderService fixtureProviderService) {
        this(webdriverInstanceFactory, environmentVariables, firefoxProfileEnhancer, fixtureProviderService, (ElementProxyCreator)Injectors.getInjector().getInstance(ElementProxyCreator.class));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer, FixtureProviderService fixtureProviderService, ElementProxyCreator proxyCreator) {
        this.webdriverInstanceFactory = webdriverInstanceFactory;
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = firefoxProfileEnhancer;
        this.fixtureProviderService = fixtureProviderService;
        this.proxyCreator = proxyCreator;
        this.browserStackRemoteDriverCapabilities = new BrowserStackRemoteDriverCapabilities(environmentVariables);
        this.sauceRemoteDriverCapabilities = new SauceRemoteDriverCapabilities(environmentVariables);
    }

    protected ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        if (this.usesSauceLabs() && driverType != SupportedWebDriver.HTMLUNIT) {
            return RemoteWebDriver.class;
        }
        return driverType.getWebdriverClass();
    }

    public boolean usesSauceLabs() {
        return StringUtils.isNotEmpty((CharSequence)this.sauceRemoteDriverCapabilities.getUrl());
    }

    public boolean usesBrowserStack() {
        return StringUtils.isNotEmpty((CharSequence)this.browserStackRemoteDriverCapabilities.getUrl());
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        try {
            WebDriver driver;
            if (this.isARemoteDriver(driverClass) || this.shouldUseARemoteDriver() || this.saucelabsUrlIsDefined() || this.browserStackUrlIsDefined()) {
                driver = this.newRemoteDriver();
            } else if (this.isAnAppiumDriver(driverClass)) {
                driver = this.appiumDriver();
            } else if (this.isAFirefoxDriver(driverClass)) {
                driver = this.firefoxDriver();
            } else if (this.isAnHtmlUnitDriver(driverClass)) {
                driver = this.htmlunitDriver();
            } else if (this.isAPhantomJSDriver(driverClass)) {
                this.setPhantomJSPathIfNotSet();
                driver = this.phantomJSDriver();
            } else {
                driver = this.isAChromeDriver(driverClass) ? this.chromeDriver() : (this.isASafariDriver(driverClass) ? this.safariDriver() : (this.isAnInternetExplorerDriver(driverClass) ? this.internetExplorerDriver() : (this.isAProvidedDriver(driverClass) ? this.providedDriver() : this.newDriverInstanceFrom(driverClass))));
            }
            this.setImplicitTimeoutsIfSpecified(driver);
            this.redimensionBrowser(driver);
            JavascriptSupport.activateJavascriptSupportFor(driver);
            return driver;
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate " + driverClass, cause);
        }
    }

    private void setPhantomJSPathIfNotSet() {
        if (!this.phantomJSIsAvailable()) {
            LOGGER.info("PhantomJS not on path, trying to get path from PHANTOMJS_BINARY_PATH");
            String phantomJSPath = System.getProperty("phantomjs.binary.path");
            String phantomJSPathEnvironmentProperty = System.getenv("PHANTOMJS_BINARY_PATH");
            LOGGER.info("PHANTOMJS_BINARY_PATH = " + phantomJSPathEnvironmentProperty);
            LOGGER.info("PHANTOMJS_EXECUTABLE_PATH_PROPERTY = " + phantomJSPath);
            if (StringUtils.isNotEmpty((CharSequence)phantomJSPath)) {
                System.setProperty("phantomjs.binary.path", phantomJSPath);
            } else if (StringUtils.isNotEmpty((CharSequence)phantomJSPathEnvironmentProperty)) {
                System.setProperty("phantomjs.binary.path", phantomJSPathEnvironmentProperty);
            }
        }
    }

    private boolean phantomJSIsAvailable() {
        try {
            return this.executeCommand("phantomjs -v") != 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private int executeCommand(String command) throws IOException {
        Process cmdProc = Runtime.getRuntime().exec(command);
        try {
            return cmdProc.waitFor();
        }
        catch (InterruptedException e) {
            return -1;
        }
    }

    private boolean isAProvidedDriver(Class<? extends WebDriver> driverClass) {
        return ProvidedDriver.class.isAssignableFrom(driverClass);
    }

    private WebDriver providedDriver() {
        ProvidedDriverConfiguration sourceConfig = new ProvidedDriverConfiguration(this.environmentVariables);
        try {
            return sourceConfig.getDriverSource().newDriver();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate the custom webdriver provider of type " + sourceConfig.getDriverName());
        }
    }

    private void setImplicitTimeoutsIfSpecified(WebDriver driver) {
        if (ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.isDefinedIn(this.environmentVariables)) {
            int timeout = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.getPropertyName(), (Integer)0);
            driver.manage().timeouts().implicitlyWait((long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    private boolean shouldUseARemoteDriver() {
        return ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.isDefinedIn(this.environmentVariables);
    }

    private WebDriver newDriverInstanceFrom(Class<? extends WebDriver> driverClass) throws IllegalAccessException, InstantiationException {
        return this.webdriverInstanceFactory.newInstanceOf(driverClass);
    }

    private WebDriver newRemoteDriver() throws MalformedURLException {
        WebDriver driver = null;
        driver = this.saucelabsUrlIsDefined() ? this.buildSaucelabsDriver() : (this.browserStackUrlIsDefined() ? this.buildBrowserStackDriver() : this.buildRemoteDriver());
        Augmenter augmenter = new Augmenter();
        return augmenter.augment(driver);
    }

    private WebDriver buildRemoteDriver() throws MalformedURLException {
        String remoteUrl = ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.from(this.environmentVariables);
        return this.webdriverInstanceFactory.newRemoteDriver(new URL(remoteUrl), this.buildRemoteCapabilities());
    }

    private boolean saucelabsUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.sauceRemoteDriverCapabilities.getUrl());
    }

    private boolean browserStackUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.browserStackRemoteDriverCapabilities.getUrl());
    }

    private WebDriver buildSaucelabsDriver() throws MalformedURLException {
        String saucelabsUrl = this.sauceRemoteDriverCapabilities.getUrl();
        WebDriver driver = this.webdriverInstanceFactory.newRemoteDriver(new URL(saucelabsUrl), this.findSaucelabsCapabilities());
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.from(this.environmentVariables))) {
            int implicitWait = ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.integerFrom(this.environmentVariables, 30);
            driver.manage().timeouts().implicitlyWait((long)implicitWait, TimeUnit.SECONDS);
        }
        return driver;
    }

    private WebDriver buildBrowserStackDriver() throws MalformedURLException {
        String browserStackUrl = this.browserStackRemoteDriverCapabilities.getUrl();
        WebDriver driver = this.webdriverInstanceFactory.newRemoteDriver(new URL(browserStackUrl), this.findbrowserStackCapabilities());
        return driver;
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables, String defaultDriver) {
        String driver = WebDriverFactory.getDriverFrom(environmentVariables);
        return driver != null ? driver : defaultDriver;
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables) {
        String driver = ThucydidesSystemProperty.WEBDRIVER_DRIVER.from(environmentVariables);
        if (driver == null) {
            driver = ThucydidesSystemProperty.DRIVER.from(environmentVariables);
        }
        return driver;
    }

    private Capabilities findSaucelabsCapabilities() {
        String driver = WebDriverFactory.getDriverFrom(this.environmentVariables);
        DesiredCapabilities capabilities = this.capabilitiesForDriver(driver);
        return this.sauceRemoteDriverCapabilities.getCapabilities(capabilities);
    }

    private Capabilities findbrowserStackCapabilities() {
        String driver = WebDriverFactory.getDriverFrom(this.environmentVariables);
        DesiredCapabilities capabilities = this.capabilitiesForDriver(driver);
        return this.browserStackRemoteDriverCapabilities.getCapabilities(capabilities);
    }

    private Capabilities buildRemoteCapabilities() {
        String driver = ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables);
        if (driver == null) {
            driver = WebDriverFactory.getDriverFrom(this.environmentVariables);
        }
        return this.capabilitiesForDriver(driver);
    }

    private DesiredCapabilities capabilitiesForDriver(String driver) {
        if (driver == null) {
            driver = REMOTE_DRIVER;
        }
        SupportedWebDriver driverType = this.driverTypeFor(driver);
        Preconditions.checkNotNull((Object)((Object)driverType), (Object)"Unsupported remote driver type: ");
        if (driverType == SupportedWebDriver.REMOTE) {
            return (DesiredCapabilities)this.enhancedCapabilities(this.remoteCapabilities());
        }
        return (DesiredCapabilities)this.enhancedCapabilities(this.realBrowserCapabilities(driverType));
    }

    private SupportedWebDriver driverTypeFor(String driver) {
        String normalizedDriverName = driver.toUpperCase();
        if (!SupportedWebDriver.listOfSupportedDrivers().contains(normalizedDriverName)) {
            SupportedWebDriver closestDriver = SupportedWebDriver.getClosestDriverValueTo(normalizedDriverName);
            throw new AssertionError((Object)("Unsupported driver for webdriver.driver or webdriver.remote.driver: " + driver + ". Did you mean " + closestDriver.toString().toLowerCase() + "?"));
        }
        return SupportedWebDriver.valueOf(normalizedDriverName);
    }

    private DesiredCapabilities realBrowserCapabilities(SupportedWebDriver driverType) {
        DesiredCapabilities capabilities = null;
        switch (driverType) {
            case CHROME: {
                capabilities = this.chromeCapabilities();
                break;
            }
            case SAFARI: {
                capabilities = DesiredCapabilities.safari();
                break;
            }
            case FIREFOX: {
                capabilities = DesiredCapabilities.firefox();
                capabilities.setCapability("firefox_profile", (Object)this.buildFirefoxProfile());
                break;
            }
            case HTMLUNIT: {
                capabilities = DesiredCapabilities.htmlUnit();
                break;
            }
            case OPERA: {
                capabilities = DesiredCapabilities.opera();
                break;
            }
            case IEXPLORER: {
                capabilities = DesiredCapabilities.internetExplorer();
                break;
            }
            case APPIUM: {
                capabilities = this.appiumCapabilities();
                break;
            }
            default: {
                capabilities = new DesiredCapabilities();
                capabilities.setJavascriptEnabled(true);
            }
        }
        return (DesiredCapabilities)this.enhancedCapabilities(capabilities);
    }

    private DesiredCapabilities remoteCapabilities() {
        String remoteBrowser = ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables, DEFAULT_DRIVER);
        DesiredCapabilities capabilities = this.realBrowserCapabilities(this.driverTypeFor(remoteBrowser));
        capabilities.setCapability("idle-timeout", (Object)this.EXTRA_TIME_TO_TAKE_SCREENSHOTS);
        Boolean recordScreenshotsInSaucelabs = ThucydidesSystemProperty.SAUCELABS_RECORD_SCREENSHOTS.booleanFrom(this.environmentVariables);
        capabilities.setCapability("record-screenshots", (Object)recordScreenshotsInSaucelabs);
        if (this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS) != null) {
            capabilities.setCapability("platform", Platform.valueOf((String)this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS)));
        }
        if (this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION) != null) {
            capabilities.setCapability("version", Platform.valueOf((String)this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION)));
        }
        return capabilities;
    }

    private DesiredCapabilities addExtraCatabilitiesTo(DesiredCapabilities capabilities) {
        CapabilitySet capabilitySet = new CapabilitySet(this.environmentVariables);
        Map<String, Object> extraCapabilities = capabilitySet.getCapabilities();
        for (String capabilityName : extraCapabilities.keySet()) {
            capabilities.setCapability(capabilityName, extraCapabilities.get(capabilityName));
        }
        this.addCapabilitiesFromFixtureServicesTo(capabilities);
        return capabilities;
    }

    public void setupFixtureServices() throws FixtureException {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.setup();
        }
    }

    public void shutdownFixtureServices() {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.shutdown();
        }
    }

    private void addCapabilitiesFromFixtureServicesTo(DesiredCapabilities capabilities) {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.addCapabilitiesTo(capabilities);
        }
    }

    private WebDriver htmlunitDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.setJavascriptEnabled(true);
        return this.webdriverInstanceFactory.newHtmlUnitDriver(this.enhancedCapabilities(capabilities));
    }

    private WebDriver phantomJSDriver() {
        DesiredCapabilities capabilities = DesiredCapabilities.phantomjs();
        PhantomJSCapabilityEnhancer enhancer = new PhantomJSCapabilityEnhancer(this.environmentVariables);
        enhancer.enhanceCapabilities(capabilities);
        return this.webdriverInstanceFactory.newPhantomDriver(this.enhancedCapabilities(capabilities));
    }

    private WebDriver firefoxDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        FirefoxProfile profile = this.buildFirefoxProfile();
        DesiredCapabilities capabilities = DesiredCapabilities.firefox();
        capabilities.setCapability("firefox_profile", (Object)profile);
        return this.webdriverInstanceFactory.newFirefoxDriver(this.enhancedCapabilities(capabilities));
    }

    private WebDriver chromeDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        DesiredCapabilities capabilities = this.chromeCapabilities();
        this.updateChromePathIfSpecifiedIn(this.environmentVariables);
        return this.webdriverInstanceFactory.newChromeDriver(this.enhancedCapabilities(capabilities));
    }

    private void updateChromePathIfSpecifiedIn(EnvironmentVariables environmentVariables) {
        String environmentDefinedChromeDriverPath = environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_DRIVER);
        if (StringUtils.isNotEmpty((CharSequence)environmentDefinedChromeDriverPath)) {
            System.setProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_DRIVER.toString(), environmentDefinedChromeDriverPath);
        }
    }

    private DesiredCapabilities chromeCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        capabilities.setCapability("chromeOptions", (Object)this.optionsFromSwitches(chromeSwitches));
        capabilities.setCapability("chrome.switches", chromeSwitches);
        return capabilities;
    }

    private WebDriver appiumDriver() {
        return this.webdriverInstanceFactory.newAppiumDriver(this.appiumUrl(), this.enhancedCapabilities(this.appiumCapabilities()), this.appiumTargetPlatform());
    }

    private MobilePlatform appiumTargetPlatform() {
        return AppiumConfiguration.from(this.environmentVariables).getTargetPlatform();
    }

    private URL appiumUrl() {
        return AppiumConfiguration.from(this.environmentVariables).getUrl();
    }

    private DesiredCapabilities appiumCapabilities() {
        return AppiumConfiguration.from(this.environmentVariables).getCapabilities();
    }

    private ChromeOptions optionsFromSwitches(String chromeSwitches) {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"test-type"});
        if (StringUtils.isNotEmpty((CharSequence)chromeSwitches)) {
            List<String> arguments = new OptionsSplitter().split(chromeSwitches);
            options.addArguments(arguments);
        }
        return options;
    }

    private WebDriver safariDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.webdriverInstanceFactory.newSafariDriver(this.enhancedCapabilities(DesiredCapabilities.safari()));
    }

    private WebDriver internetExplorerDriver() {
        return this.webdriverInstanceFactory.newInternetExplorerDriver(this.enhancedCapabilities(DesiredCapabilities.internetExplorer()));
    }

    private Capabilities enhancedCapabilities(DesiredCapabilities capabilities) {
        return this.addExtraCatabilitiesTo(capabilities);
    }

    private Dimension getRequestedBrowserSize() {
        int height = ThucydidesSystemProperty.THUCYDIDES_BROWSER_HEIGHT.integerFrom(this.environmentVariables, 700);
        int width = ThucydidesSystemProperty.THUCYDIDES_BROWSER_WIDTH.integerFrom(this.environmentVariables, 960);
        return new Dimension(width, height);
    }

    private void redimensionBrowser(WebDriver driver) {
        if (this.supportsScreenResizing(driver) && this.browserDimensionsSpecified()) {
            this.resizeBrowserTo(driver, this.getRequestedBrowserSize().height, this.getRequestedBrowserSize().width);
        }
    }

    private boolean browserDimensionsSpecified() {
        String snapshotWidth = ThucydidesSystemProperty.THUCYDIDES_BROWSER_WIDTH.from(this.environmentVariables);
        String snapshotHeight = ThucydidesSystemProperty.THUCYDIDES_BROWSER_HEIGHT.from(this.environmentVariables);
        return snapshotWidth != null || snapshotHeight != null;
    }

    private boolean supportsScreenResizing(WebDriver driver) {
        return this.isNotAMocked(driver) && !this.isAnHtmlUnitDriver(this.getDriverClass(driver));
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock");
    }

    protected void resizeBrowserTo(WebDriver driver, int height, int width) {
        LOGGER.info("Setting browser dimensions to {}/{}", (Object)height, (Object)width);
        driver.manage().window().setSize(new Dimension(width, height));
        driver.manage().window().setPosition(new Point(0, 0));
    }

    private boolean isARemoteDriver(Class<? extends WebDriver> driverClass) {
        return RemoteWebDriver.class == driverClass;
    }

    private boolean isAFirefoxDriver(Class<? extends WebDriver> driverClass) {
        return FirefoxDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAChromeDriver(Class<? extends WebDriver> driverClass) {
        return ChromeDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isASafariDriver(Class<? extends WebDriver> driverClass) {
        return SafariDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAnInternetExplorerDriver(Class<? extends WebDriver> driverClass) {
        return InternetExplorerDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAnAppiumDriver(Class<? extends WebDriver> driverClass) {
        return AppiumDriver.class.isAssignableFrom(driverClass);
    }

    private boolean usesFirefox(WebDriver driver) {
        return FirefoxDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private boolean usesInternetExplorer(WebDriver driver) {
        return InternetExplorerDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private boolean usesChrome(WebDriver driver) {
        return ChromeDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private Class getDriverClass(WebDriver driver) {
        Class<Object> driverClass = null;
        driverClass = driver instanceof WebDriverFacade ? ((WebDriverFacade)driver).getDriverClass() : driver.getClass();
        return driverClass;
    }

    private boolean isAnHtmlUnitDriver(Class<? extends WebDriver> driverClass) {
        return HtmlUnitDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAPhantomJSDriver(Class<? extends WebDriver> driverClass) {
        return PhantomJSDriver.class.isAssignableFrom(driverClass);
    }

    private boolean usesPhantomJS(WebDriver driver) {
        return PhantomJSDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    protected FirefoxProfile createNewFirefoxProfile() {
        FirefoxProfile profile;
        if (Serenity.getFirefoxProfile() != null) {
            profile = Serenity.getFirefoxProfile();
        } else {
            profile = new FirefoxProfile();
            profile.setPreference("network.proxy.socks_port", 9999);
            profile.setAlwaysLoadNoFocusLib(true);
            profile.setEnableNativeEvents(true);
        }
        return profile;
    }

    protected FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    protected FirefoxProfile buildFirefoxProfile() {
        String profileName = ThucydidesSystemProperty.WEBDRIVER_FIREFOX_PROFILE.from(this.environmentVariables);
        FilePathParser parser = new FilePathParser(this.environmentVariables);
        DesiredCapabilities firefoxCapabilities = DesiredCapabilities.firefox();
        if (StringUtils.isNotEmpty((CharSequence)profileName)) {
            firefoxCapabilities.setCapability("firefox_profile", parser.getInstanciatedPath(profileName));
        }
        FirefoxProfile profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
        this.firefoxProfileEnhancer.allowWindowResizeFor(profile);
        this.firefoxProfileEnhancer.activateNativeEventsFor(profile, this.shouldEnableNativeEvents());
        if (this.shouldActivateProxy()) {
            this.activateProxyFor(profile, this.firefoxProfileEnhancer);
        }
        if (this.firefoxProfileEnhancer.shouldActivateFirebugs()) {
            this.firefoxProfileEnhancer.addFirebugsTo(profile);
        }
        if (this.refuseUntrustedCertificates()) {
            profile.setAssumeUntrustedCertificateIssuer(false);
            profile.setAcceptUntrustedCertificates(false);
        } else {
            profile.setAssumeUntrustedCertificateIssuer(true);
            profile.setAcceptUntrustedCertificates(true);
        }
        this.firefoxProfileEnhancer.configureJavaSupport(profile);
        this.firefoxProfileEnhancer.addPreferences(profile);
        return profile;
    }

    private boolean shouldEnableNativeEvents() {
        return Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_NATIVE_EVENTS.from(this.environmentVariables, "true"));
    }

    private void activateProxyFor(FirefoxProfile profile, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        String proxyPort = this.getProxyPortFromEnvironmentVariables();
        firefoxProfileEnhancer.activateProxy(profile, proxyUrl, proxyPort);
    }

    private String getProxyPortFromEnvironmentVariables() {
        return ThucydidesSystemProperty.THUCYDIDES_PROXY_HTTP_PORT.from(this.environmentVariables);
    }

    private boolean shouldActivateProxy() {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        return StringUtils.isNotEmpty((CharSequence)proxyUrl);
    }

    private String getProxyUrlFromEnvironmentVariables() {
        return ThucydidesSystemProperty.THUCYDIDES_PROXY_HTTP.from(this.environmentVariables);
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    private boolean refuseUntrustedCertificates() {
        return ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.booleanFrom(this.environmentVariables);
    }

    public void initElementsWithAjaxSupport(PageObject pageObject, WebDriver driver, int timeoutInSeconds) {
        this.proxyCreator.proxyElements(pageObject, driver, timeoutInSeconds);
    }
}

