/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.pages.PageObject;
import net.thucydides.core.annotations.locators.SmartElementProxyCreator;
import net.thucydides.core.webdriver.ElementProxyCreator;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.Duration;

public class DefaultPageObjectInitialiser
implements Predicate<PageObject> {
    private final WebDriver driver;
    private final Duration ajaxTimeout;
    private final ElementProxyCreator elementProxyCreator;

    public DefaultPageObjectInitialiser(WebDriver driver, long ajaxTimeoutInMilliseconds) {
        this.driver = driver;
        this.ajaxTimeout = new Duration(ajaxTimeoutInMilliseconds, TimeUnit.MILLISECONDS);
        this.elementProxyCreator = new SmartElementProxyCreator();
    }

    protected int ajaxTimeoutInSecondsWithAtLeast1Second() {
        return (int)(this.ajaxTimeout.in(TimeUnit.SECONDS) > 0L ? this.ajaxTimeout.in(TimeUnit.SECONDS) : 1L);
    }

    public boolean apply(PageObject page) {
        page.setWaitForTimeout(this.ajaxTimeout.in(TimeUnit.MILLISECONDS));
        this.elementProxyCreator.proxyElements(page, this.driver, this.ajaxTimeoutInSecondsWithAtLeast1Second());
        return true;
    }
}

