/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import ch.lambdaj.function.convert.DefaultStringConverter;
import java.util.List;
import java.util.Properties;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;

public class MockEnvironmentVariables
implements EnvironmentVariables {
    private Properties properties = new Properties();
    private Properties values = new Properties();

    public MockEnvironmentVariables() {
        this.properties.setProperty("user.home", System.getProperty("user.home"));
    }

    protected MockEnvironmentVariables(Properties properties) {
        this.properties = PropertiesUtil.copyOf(properties);
    }

    protected MockEnvironmentVariables(Properties properties, Properties values) {
        this.properties = PropertiesUtil.copyOf(properties);
        this.values = PropertiesUtil.copyOf(values);
    }

    public static EnvironmentVariables fromSystemEnvironment() {
        return new MockEnvironmentVariables(System.getProperties());
    }

    public boolean propertySetIsEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public String getValue(String name) {
        return this.values.getProperty(name);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        return this.values.getProperty(name, defaultValue);
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public Integer getPropertyAsInteger(String name, Integer defaultValue) {
        String value = (String)this.properties.get(name);
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        return defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.properties.getProperty(name) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.properties.getProperty(name, "false"));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void clearProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public EnvironmentVariables copy() {
        return new MockEnvironmentVariables(this.properties, this.values);
    }

    @Override
    public List<String> getKeys() {
        return Lambda.convert(this.properties.keySet(), (Converter)new DefaultStringConverter());
    }

    public void setValue(String name, String value) {
        this.values.setProperty(name, value);
    }
}

